/*
 * Decompiled with CFR 0.152.
 */
package orbital.util.graph;

import java.util.Iterator;
import orbital.util.StreamMethod;
import orbital.util.graph.ListGraph;
import orbital.util.graph.ListJungle;
import orbital.util.graph.Node;

public class ListTree
extends ListJungle {
    public ListTree(TreeNode root) {
        super(root);
    }

    public void setRoot(Node root) {
        if (!(root instanceof TreeNode)) {
            throw new IllegalArgumentException("can only handle nodes of type " + TreeNode.class);
        }
        ((TreeNode)root).setParent(null);
        super.setRoot(root);
    }

    public Iterator preorder() {
        return new StreamMethod(true){

            public void runStream() {
                this.visit(ListTree.this.getRoot());
            }

            protected final void visit(Node node) {
                this.resumedReturn(node);
                Iterator i = node.edges();
                while (i.hasNext()) {
                    this.visit((Node)i.next());
                }
            }
        }.apply();
    }

    public Iterator inorder() {
        return new StreamMethod(true){

            public void runStream() {
                this.visit(ListTree.this.getRoot());
            }

            protected final void visit(Node node) {
                if (node.isLeaf()) {
                    this.resumedReturn(node);
                    return;
                }
                Iterator i = node.edges();
                while (i.hasNext()) {
                    this.visit((Node)i.next());
                    if (!i.hasNext()) continue;
                    this.resumedReturn(node);
                }
            }
        }.apply();
    }

    public Iterator postorder() {
        return new StreamMethod(true){

            public void runStream() {
                this.visit(ListTree.this.getRoot());
            }

            protected final void visit(Node node) {
                Iterator i = node.edges();
                while (i.hasNext()) {
                    this.visit((Node)i.next());
                }
                this.resumedReturn(node);
            }
        }.apply();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.preorder();
        while (i.hasNext()) {
            sb.append(i.next() + (i.hasNext() ? "," : ""));
        }
        return this.getClass().getName() + "[" + sb.toString() + "]";
    }

    public static class TreeNode
    extends ListGraph.GraphNode {
        protected TreeNode parent = null;

        public TreeNode(Object key, Object data) {
            super(key, data);
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        public boolean add(Node n) {
            ((TreeNode)n).setParent(this);
            return this.children.add(n);
        }

        public boolean remove(Node n) {
            ((TreeNode)n).setParent(null);
            return this.children.remove(n);
        }
    }
}

