/*
 * Decompiled with CFR 0.152.
 */
package orbital.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import orbital.util.DelegateList;

public class QueuedIterator
extends DelegateList
implements Iterator,
Serializable {
    public QueuedIterator(boolean synchronizedQueue) {
        super(synchronizedQueue ? Collections.synchronizedList(new LinkedList()) : new LinkedList());
    }

    public QueuedIterator() {
        this(false);
    }

    public boolean hasNext() {
        return !this.isEmpty();
    }

    public Object next() {
        try {
            return this.remove(0);
        }
        catch (IndexOutOfBoundsException x) {
            throw new NoSuchElementException();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("senseless, has already been removed from the queue on the call to next");
    }

    public boolean addAll(Iterator i) {
        boolean changed = false;
        while (i.hasNext()) {
            changed |= this.add(i.next());
        }
        return changed;
    }
}

