/*
 * Decompiled with CFR 0.152.
 */
package orbital.robotic.strategy;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import orbital.logic.functor.Function;
import orbital.robotic.strategy.NumberWeighting;
import orbital.robotic.strategy.Selection;
import orbital.util.Pair;

public class Evaluation
implements Function {
    protected Function weighting;
    protected Selection selection;
    protected final List elements;
    protected final List weights;

    public Evaluation(Selection selection, Function weighting) {
        this.selection = selection;
        this.weighting = weighting;
        this.elements = new LinkedList();
        this.weights = new LinkedList();
    }

    public Evaluation(Function weighting) {
        this(Selection.Selecting.best(), weighting);
    }

    public Evaluation() {
        this(Selection.Selecting.best(), new NumberWeighting());
    }

    public Function getWeighting() {
        return this.weighting;
    }

    public void setWeighting(Function w) {
        this.weighting = w;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void setSelection(Selection select) {
        this.selection = select;
    }

    public List getWeights() {
        return Collections.unmodifiableList(this.weights);
    }

    public List getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public void clear() {
        this.weights.clear();
        this.elements.clear();
    }

    public boolean add(Object arg) {
        this.weightImpl(arg);
        return true;
    }

    public void addAll(Collection list) {
        Iterator i = list.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public Object apply(Object arg) {
        return this.weightImpl(arg);
    }

    public Object evaluate() {
        return this.evaluate(this.selection);
    }

    public static Object getArg(Object evaluated) {
        if (evaluated instanceof Pair) {
            Object h = ((Pair)evaluated).B;
            while (h instanceof Pair) {
                evaluated = h;
                h = ((Pair)h).B;
            }
        }
        return evaluated;
    }

    protected synchronized void add(Object el, Object weight) {
        this.elements.add(el);
        this.weights.add(weight);
    }

    protected Object weightImpl(Object arg) {
        Object weight = this.weighting.apply(arg);
        this.add(arg, weight);
        return weight;
    }

    private Object evaluate(Selection selection) {
        Object ev = this.evaluateMe(selection);
        if (this.weighting instanceof Evaluation) {
            Object subev = ((Evaluation)this.weighting).evaluate();
            return new Pair(ev, subev);
        }
        return ev;
    }

    private Object evaluateMe(Selection selection) {
        int selected = selection.select(Collections.unmodifiableList(this.weights));
        if (selected < 0) {
            return null;
        }
        return this.elements.get(selected);
    }
}

