/*
 * Decompiled with CFR 0.152.
 */
package orbital.robotic;

import java.io.Serializable;
import orbital.robotic.Position;

public class Direction
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3508145947359548778L;
    public static final int East = 0;
    public static final int SouthEast = 45;
    public static final int South = 90;
    public static final int SouthWest = 135;
    public static final int West = 180;
    public static final int NorthWest = 225;
    public static final int North = 270;
    public static final int NorthEast = 315;
    public static final int Left = -90;
    public static final int HalfLeft = -45;
    public static final int HalfRight = 45;
    public static final int Right = 90;
    public static final int Back = 180;
    public static final int For = 0;
    public int direction;
    private static final String[] absDirections = new String[]{"East", "SouthEast", "South", "SouthWest", "West", "NorthWest", "North", "NorthEast"};
    private static final String[] relDirections = new String[]{"Left", "HalfLeft", "For", "HalfRight", "Right", null, "Back", null, null, null, "For"};

    public Direction(int dir) {
        this.direction = dir;
    }

    public Direction() {
        this(270);
    }

    public Direction(Direction dir) {
        this(dir.direction);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException imp) {
            throw new InternalError("clone not supported though Cloneable");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Direction) {
            return this.direction == ((Direction)obj).direction;
        }
        return false;
    }

    public int hashCode() {
        return this.direction;
    }

    public void setDirection(int new_Dir) {
        this.direction = new_Dir;
    }

    public int getDirection() {
        return this.direction;
    }

    public Position getDirectionVector() {
        switch (this.direction) {
            case 0: {
                return new Position(1, 0);
            }
            case 45: {
                return new Position(1, 1);
            }
            case 90: {
                return new Position(0, 1);
            }
            case 135: {
                return new Position(-1, 1);
            }
            case 180: {
                return new Position(-1, 0);
            }
            case 225: {
                return new Position(-1, -1);
            }
            case 270: {
                return new Position(0, -1);
            }
            case 315: {
                return new Position(1, -1);
            }
        }
        throw new IllegalStateException("illegal direction: " + this.direction);
    }

    public void turn(int rel_turn_dir) {
        this.direction = this.getTurned(rel_turn_dir);
    }

    final int getTurned(int rel_turn_dir) {
        int dir = (this.direction + rel_turn_dir) % 360;
        return dir < 0 ? dir + 360 : dir;
    }

    public String toString() {
        return Direction.nameOfAbsolute(this.direction);
    }

    public static final String nameOfAbsolute(int direction) {
        return absDirections[direction / 45];
    }

    public static final String nameOfRelative(int direction) {
        return relDirections[2 + direction / 45];
    }
}

