/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math.functional;

import orbital.math.Arithmetic;
import orbital.math.Metric;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Values;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.MathFunctor;
import orbital.math.functional.Operations;

public abstract class AbstractFunctor
implements MathFunctor {
    public boolean equals(Object o, Real tolerance) {
        return Metric.INDUCED.distance(this, (MathFunctor)o).compareTo(tolerance) < 0;
    }

    public Arithmetic zero() {
        return Functions.zero;
    }

    public Arithmetic one() {
        return Functions.one;
    }

    public Arithmetic add(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar && Values.ZERO.equals(b)) {
            return this;
        }
        return Functionals.genericCompose(Operations.plus, (Object)this, (Object)b);
    }

    public Arithmetic minus() throws ArithmeticException {
        return Functionals.genericCompose(Operations.minus, (Object)this);
    }

    public Arithmetic subtract(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar && Values.ZERO.equals(b)) {
            return this;
        }
        return Functionals.genericCompose(Operations.subtract, (Object)this, (Object)b);
    }

    public Arithmetic scale(Arithmetic alpha) throws ArithmeticException {
        return this.multiply(alpha);
    }

    public Arithmetic multiply(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar) {
            if (Values.ONE.equals(b)) {
                return this;
            }
            if (Values.MINUS_ONE.equals(b)) {
                return this.minus();
            }
            if (Values.ZERO.equals(b)) {
                return Values.ZERO;
            }
        }
        return Functionals.genericCompose(Operations.times, (Object)this, (Object)b);
    }

    public Arithmetic inverse() throws ArithmeticException {
        return Functionals.genericCompose(Operations.inverse, (Object)this);
    }

    public Arithmetic divide(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar) {
            if (Values.ONE.equals(b)) {
                return this;
            }
            if (Values.MINUS_ONE.equals(b)) {
                return this.minus();
            }
            if (Values.ZERO.equals(b)) {
                throw new ArithmeticException("division by zero");
            }
        }
        return Functionals.genericCompose(Operations.divide, (Object)this, (Object)b);
    }

    public Arithmetic power(Arithmetic b) throws ArithmeticException {
        if (b instanceof Scalar) {
            if (Values.ONE.equals(b)) {
                return this;
            }
            if (Values.MINUS_ONE.equals(b)) {
                return this.inverse();
            }
            if (Values.ZERO.equals(b)) {
                return Values.ONE;
            }
        }
        return Functionals.genericCompose(Operations.power, (Object)this, (Object)b);
    }

    public Real norm() {
        return Values.NaN;
    }
}

