/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.awt.Dimension;
import orbital.math.Arithmetic;
import orbital.math.Matrix;
import orbital.math.Vector;
import orbital.moon.math.AbstractMatrix;
import orbital.moon.math.ArithmeticVector;
import orbital.util.Utility;

class ArithmeticMatrix
extends AbstractMatrix {
    private static final long serialVersionUID = -2994686890096422385L;
    Arithmetic[][] D;

    public ArithmeticMatrix(int height, int width) {
        this.D = new Arithmetic[height][width];
    }

    public ArithmeticMatrix(Dimension dim) {
        this(dim.height, dim.width);
    }

    public ArithmeticMatrix(Arithmetic[][] values) {
        for (int i = 1; i < values.length; ++i) {
            Utility.pre(values[i].length == values[i - 1].length, "rectangular array required");
        }
        this.D = values;
    }

    protected Matrix newInstance(Dimension dim) {
        return new ArithmeticMatrix(dim);
    }

    public final Dimension dimension() {
        return new Dimension(this.D.length != 0 ? this.D[0].length : 0, this.D.length);
    }

    public Arithmetic get(int i, int j) {
        this.validate(i, j);
        return this.D[i][j];
    }

    public void set(int i, int j, Arithmetic m) {
        this.validate(i, j);
        this.D[i][j] = m;
    }

    public Vector getRow(int r) {
        this.validate(r, 0);
        return new ArithmeticVector(this.D[r]);
    }

    public void setRow(int r, Vector row) throws UnsupportedOperationException {
        this.validate(r, row.dimension() - 1);
        if (row instanceof ArithmeticVector) {
            this.D[r] = (Arithmetic[])((ArithmeticVector)row).D.clone();
        } else {
            super.setRow(r, row);
        }
    }

    protected void set(Arithmetic[][] v) {
        this.D = new Arithmetic[v.length][];
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                Utility.pre(v[i].length == v[i - 1].length, "rectangular array required");
            }
            this.D[i] = (Arithmetic[])v[i].clone();
        }
        ++this.modCount;
    }

    public Object clone() {
        return new ArithmeticMatrix(this.toArray());
    }

    public Matrix insertRows(int index, Matrix rows) {
        int i;
        if (index != this.dimension().height) {
            this.validate(index, 0);
        }
        Utility.pre(this.dimension().width == rows.dimension().width, "Matrix must have same width (number of columns)");
        Arithmetic[][] A = new Arithmetic[this.dimension().height + rows.dimension().height][this.dimension().width];
        for (i = 0; i < index; ++i) {
            A[i] = this.D[i];
        }
        if (rows instanceof ArithmeticMatrix) {
            ArithmeticMatrix m = (ArithmeticMatrix)rows;
            for (int i2 = 0; i2 < rows.dimension().height; ++i2) {
                A[index + i2] = m.D[i2];
            }
        } else {
            for (i = 0; i < rows.dimension().height; ++i) {
                for (int j = 0; j < rows.dimension().width; ++j) {
                    A[index + i][j] = rows.get(i, j);
                }
            }
        }
        for (int i3 = index; i3 < this.dimension().height; ++i3) {
            A[rows.dimension().height + i3] = this.D[i3];
        }
        this.set(A);
        return this;
    }

    public Matrix removeRow(int r) {
        int i;
        this.validate(r, 0);
        Arithmetic[][] A = new Arithmetic[this.dimension().height - 1][this.dimension().width];
        for (i = 0; i < r; ++i) {
            A[i] = this.D[i];
        }
        for (i = r + 1; i < this.dimension().height; ++i) {
            A[i - 1] = this.D[i];
        }
        this.set(A);
        return this;
    }

    public Arithmetic[][] toArray() {
        Arithmetic[][] v = new Arithmetic[this.D.length][];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (Arithmetic[])this.D[i].clone();
        }
        return v;
    }
}

