/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import orbital.math.Arithmetic;
import orbital.math.Integer;
import orbital.math.MathUtilities;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractInteger;
import orbital.moon.math.AbstractReal;
import orbital.util.Utility;

abstract class AbstractRational
extends AbstractReal
implements Rational {
    private static final long serialVersionUID = -9129018097987023600L;

    protected AbstractRational() {
    }

    public double doubleValue() {
        return (double)this.numeratorValue() / (double)this.denominatorValue();
    }

    abstract int numeratorValue();

    abstract int denominatorValue();

    public boolean equals(Object o) {
        if (Rational.isa.apply(o)) {
            return this.compareTo(o) == 0;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int compareTo(Object o) {
        if (o instanceof AbstractRational) {
            AbstractRational b = (AbstractRational)o;
            return this.numeratorValue() * b.denominatorValue() - b.numeratorValue() * this.denominatorValue();
        }
        if (Rational.isa.apply(o)) {
            Rational b = (Rational)o;
            return this.numerator().multiply(b.denominator()).compareTo(b.numerator().multiply(this.denominator()));
        }
        return super.compareTo(o);
    }

    public Real norm() {
        return Values.getDefaultInstance().rational((Integer)this.numerator().norm(), (Integer)this.denominator().norm());
    }

    public Arithmetic add(Arithmetic b) {
        if (b instanceof Rational) {
            return this.add((Rational)b);
        }
        return (Arithmetic)Operations.plus.apply(this, b);
    }

    public Arithmetic subtract(Arithmetic b) {
        if (b instanceof Rational) {
            return this.subtract((Rational)b);
        }
        return (Arithmetic)Operations.subtract.apply(this, b);
    }

    public Arithmetic multiply(Arithmetic b) {
        if (b instanceof Rational) {
            return this.multiply((Rational)b);
        }
        return (Arithmetic)Operations.times.apply(this, b);
    }

    public Arithmetic divide(Arithmetic b) {
        if (b instanceof Rational) {
            return this.divide((Rational)b);
        }
        return (Arithmetic)Operations.divide.apply(this, b);
    }

    public Rational power(Integer b) {
        return (Rational)Operations.power.apply(this, b);
    }

    public Arithmetic power(Arithmetic b) {
        if (b instanceof Integer) {
            return this.power((Integer)b);
        }
        if (b instanceof Rational) {
            return (Arithmetic)Operations.power.apply(this, Values.getDefaultInstance().valueOf(((Number)((Object)b)).doubleValue()));
        }
        return (Arithmetic)Operations.power.apply(this, b);
    }

    public Real add(Real b) {
        return (Real)Operations.plus.apply(this, b);
    }

    public Real subtract(Real b) {
        return (Real)Operations.subtract.apply(this, b);
    }

    public Real multiply(Real b) {
        return (Real)Operations.times.apply(this, b);
    }

    public Real divide(Real b) {
        return (Real)Operations.divide.apply(this, b);
    }

    public Real power(Real b) {
        return (Real)Operations.power.apply(this, b);
    }

    static class RationalImpl
    extends AbstractRational {
        private static final long serialVersionUID = -8091750706034605583L;
        private int numerator;
        private int denominator;

        public RationalImpl(int p, int q) {
            if (q < 0) {
                this.numerator = -p;
                this.denominator = -q;
            } else {
                this.numerator = p;
                this.denominator = q;
            }
        }

        public RationalImpl(int p) {
            this(p, 1);
        }

        public RationalImpl(Number p) {
            this(p.intValue(), 1);
            Utility.pre(MathUtilities.isInteger(p.doubleValue()) && (long)p.intValue() == p.longValue(), "integer value only");
        }

        public RationalImpl(Number p, Number q) {
            this(p.intValue(), q.intValue());
            Utility.pre(MathUtilities.isInteger(p.doubleValue()) && (long)p.intValue() == p.longValue() && MathUtilities.isInteger(q.doubleValue()) && (long)q.intValue() == q.longValue(), "integer value only");
        }

        public RationalImpl() {
            this(0, 1);
        }

        public Object clone() {
            return new RationalImpl(this.numerator, this.denominator);
        }

        public Integer numerator() {
            return Values.getDefaultInstance().valueOf(this.numerator);
        }

        int numeratorValue() {
            return this.numerator;
        }

        public Integer denominator() {
            return Values.getDefaultInstance().valueOf(this.denominator);
        }

        int denominatorValue() {
            return this.denominator;
        }

        public Rational add(Rational b) {
            int b_denominator = this.validate(b.denominator()).intValue();
            int m = MathUtilities.lcm(this.denominatorValue(), b_denominator);
            int f1 = m / this.denominatorValue();
            int f2 = m / b_denominator;
            return new RationalImpl(f1 * this.numeratorValue() + f2 * this.validate(b.numerator()).intValue(), m).representative();
        }

        public Rational subtract(Rational b) {
            return this.add((Rational)b.minus());
        }

        public Arithmetic minus() {
            return new RationalImpl(-this.numeratorValue(), this.denominatorValue());
        }

        public Rational multiply(Rational b) {
            return new RationalImpl(this.numeratorValue() * this.validate(b.numerator()).intValue(), this.denominatorValue() * this.validate(b.denominator()).intValue()).representative();
        }

        public Rational divide(Rational b) {
            return new RationalImpl(this.numeratorValue() * this.validate(b.denominator()).intValue(), this.denominatorValue() * this.validate(b.numerator()).intValue()).representative();
        }

        public Arithmetic inverse() {
            return new RationalImpl(this.denominatorValue(), this.numeratorValue());
        }

        public Rational power(Integer b) {
            long k = b.longValue();
            return new RationalImpl((int)Math.pow(this.numeratorValue(), k), (int)Math.pow(this.denominatorValue(), k)).representative();
        }

        public Rational representative() {
            int d;
            int p = this.numeratorValue();
            int q = this.denominatorValue();
            boolean changed = false;
            if (q < 0) {
                changed = true;
                p = -p;
                q = -q;
            }
            return (d = MathUtilities.gcd(p, q)) != 1 ? new RationalImpl(p / d, q / d) : (changed ? new RationalImpl(p, q) : this);
        }

        private Integer validate(Integer i) {
            if (i instanceof AbstractInteger.Long) {
                return i;
            }
            if (!(i instanceof AbstractInteger.Int)) {
                throw new UnsupportedOperationException("the precision of " + i.getClass() + " is currently not yet supported");
            }
            return i;
        }
    }
}

