/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import orbital.math.Arithmetic;
import orbital.math.Complex;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Values;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractReal;
import orbital.moon.math.AbstractScalar;

abstract class AbstractComplex
extends AbstractScalar
implements Complex {
    private static final long serialVersionUID = 6174516422770428710L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractComplex() {
    }

    public int compareTo(Object o) {
        throw new UnsupportedOperationException("complex numbers not ordered");
    }

    public boolean equals(Object o) {
        if (Complex.isa.apply(o)) {
            Complex b = (Complex)o;
            return this.re().equals(b.re()) && this.im().equals(b.im());
        }
        if (o != null && Values.isPrimitiveWrapper(o.getClass())) {
            if (this.equals(Values.getDefaultInstance().valueOf((Number)o))) {
                throw new IllegalArgumentException("comparing " + Scalar.class.getName() + "s with primitive wrapper type " + o.getClass() + " is not supported (since then Object.equals(Object) is symmetric)");
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.realValue());
        int hash = (int)(bits ^ bits >>> 32);
        bits = Double.doubleToLongBits(this.imaginaryValue());
        if (!$assertionsDisabled && this.imaginaryValue() == 0.0 && (hash ^= (int)(bits ^ bits >>> 32)) != Values.getDefaultInstance().valueOf(this.realValue()).hashCode()) {
            throw new AssertionError((Object)"for im()=0, hash is already the same return value as for reals");
        }
        return hash;
    }

    public double doubleValue() {
        if (this.imaginaryValue() == 0.0) {
            return this.realValue();
        }
        throw new UnsupportedOperationException("complex value has no real value");
    }

    abstract double realValue();

    abstract double imaginaryValue();

    public Real norm() {
        return Values.getDefaultInstance().valueOf(Math.sqrt(this.normSquare()));
    }

    double normSquare() {
        double real = this.realValue();
        double imaginary = this.imaginaryValue();
        return real * real + imaginary * imaginary;
    }

    public Real arg() {
        return Values.getDefaultInstance().valueOf(Math.atan2(this.imaginaryValue(), this.realValue()));
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.realValue()) || Double.isInfinite(this.imaginaryValue());
    }

    public boolean isNaN() {
        return Double.isNaN(this.realValue()) || Double.isNaN(this.imaginaryValue());
    }

    public Arithmetic zero() {
        return Values.ZERO;
    }

    public Arithmetic one() {
        return Values.ONE;
    }

    public Complex power(Complex x) {
        return (Complex)Functions.exp.apply(x.multiply((Complex)Functions.log.apply(this)));
    }

    public Arithmetic add(Arithmetic b) {
        if (b instanceof Complex) {
            return this.add((Complex)b);
        }
        return (Arithmetic)Operations.plus.apply(this, b);
    }

    public Arithmetic subtract(Arithmetic b) {
        if (b instanceof Complex) {
            return this.subtract((Complex)b);
        }
        return (Arithmetic)Operations.subtract.apply(this, b);
    }

    public Arithmetic multiply(Arithmetic b) {
        if (b instanceof Complex) {
            return this.multiply((Complex)b);
        }
        return (Arithmetic)Operations.times.apply(this, b);
    }

    public Arithmetic divide(Arithmetic b) {
        if (b instanceof Complex) {
            return this.divide((Complex)b);
        }
        return (Arithmetic)Operations.divide.apply(this, b);
    }

    public Arithmetic power(Arithmetic x) {
        return (Arithmetic)Functions.exp.apply(x.multiply((Complex)Functions.log.apply(this)));
    }

    static {
        $assertionsDisabled = !AbstractComplex.class.desiredAssertionStatus();
    }

    static class ComplexImpl
    extends AbstractComplex {
        private static final long serialVersionUID = -4910740689136774872L;
        private double real;
        private double imaginary;

        public ComplexImpl(double a, double b) {
            this.real = a;
            this.imaginary = b;
        }

        public ComplexImpl(Number a, Number b) {
            this(a.doubleValue(), b.doubleValue());
        }

        public ComplexImpl(Real a, Real b) {
            this(a.doubleValue(), b.doubleValue());
            if (!(a instanceof AbstractReal.Double || a instanceof AbstractReal.Float || a instanceof Rational)) {
                throw new UnsupportedOperationException("the precision of " + a.getClass() + " is currently not yet supported");
            }
            if (!(b instanceof AbstractReal.Double || b instanceof AbstractReal.Float || b instanceof Rational)) {
                throw new UnsupportedOperationException("the precision of " + b.getClass() + " is currently not yet supported");
            }
        }

        public ComplexImpl(double real) {
            this(real, 0.0);
        }

        public ComplexImpl(Number real) {
            this(real.doubleValue(), 0.0);
        }

        public ComplexImpl() {
            this(0.0, 0.0);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ComplexImpl) {
                AbstractComplex b = (AbstractComplex)o;
                return Double.doubleToLongBits(this.realValue()) == Double.doubleToLongBits(b.realValue()) && Double.doubleToLongBits(this.imaginaryValue()) == Double.doubleToLongBits(b.imaginaryValue());
            }
            return super.equals(o);
        }

        public boolean equals(Object o, Real tolerance) {
            if (o instanceof ComplexImpl) {
                double deltaim;
                AbstractComplex b = (AbstractComplex)o;
                double deltare = this.realValue() - b.realValue();
                return deltare * deltare + (deltaim = this.imaginaryValue() - b.imaginaryValue()) * deltaim < tolerance.doubleValue();
            }
            return super.equals(o, tolerance);
        }

        public Object clone() {
            return new ComplexImpl(this.real, this.imaginary);
        }

        public Real re() {
            return Values.getDefaultInstance().valueOf(this.real);
        }

        double realValue() {
            return this.real;
        }

        public Real im() {
            return Values.getDefaultInstance().valueOf(this.imaginary);
        }

        double imaginaryValue() {
            return this.imaginary;
        }

        public Complex conjugate() {
            return new ComplexImpl(this.realValue(), -this.imaginaryValue());
        }

        public Complex add(Complex b) {
            return new ComplexImpl(this.re().add(b.re()), this.im().add(b.im()));
        }

        public Complex subtract(Complex b) {
            return new ComplexImpl(this.re().subtract(b.re()), this.im().subtract(b.im()));
        }

        public Complex multiply(Complex b) {
            return new ComplexImpl(this.re().multiply(b.re()).subtract(this.im().multiply(b.im())), this.re().multiply(b.im()).add(this.im().multiply(b.re())));
        }

        public Complex divide(Complex b) {
            return this.multiply((Complex)b.inverse());
        }

        public Arithmetic minus() {
            return new ComplexImpl(-this.realValue(), -this.imaginaryValue());
        }

        public Arithmetic inverse() {
            double s = this.normSquare();
            return new ComplexImpl(this.realValue() / s, -this.imaginaryValue() / s);
        }
    }
}

