/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import orbital.math.Arithmetic;
import orbital.math.Integer;
import orbital.math.Metric;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Values;

abstract class AbstractArithmetic
implements Arithmetic {
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractArithmetic() {
    }

    public boolean equals(Object o, Real tolerance) {
        return Metric.INDUCED.distance(this, (Arithmetic)o).compareTo(tolerance) < 0;
    }

    public Arithmetic subtract(Arithmetic b) throws ArithmeticException {
        return this.add(b.minus());
    }

    public Arithmetic divide(Arithmetic b) throws ArithmeticException, UnsupportedOperationException {
        return this.multiply(b.inverse());
    }

    public Arithmetic power(Arithmetic b) throws ArithmeticException, UnsupportedOperationException {
        Integer s;
        if (!(b instanceof Scalar)) {
            throw new UnsupportedOperationException("default power only implemented for scalar numbers");
        }
        try {
            if (!$assertionsDisabled && !(b instanceof Scalar)) {
                throw new AssertionError();
            }
            s = (Integer)Values.getDefaultInstance().narrow((Scalar)b);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("default power only implemented for scalar integer numbers");
        }
        Arithmetic r = this;
        int n = Math.abs(s.intValue());
        for (int i = 0; i < n; ++i) {
            r = r.multiply(this);
        }
        if (s.intValue() < 0) {
            r = r.inverse();
        }
        return r;
    }

    static {
        $assertionsDisabled = !AbstractArithmetic.class.desiredAssertionStatus();
    }
}

