/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.awt;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Customizer;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import orbital.awt.CustomizerViewController;
import orbital.awt.NumberInput;
import orbital.awt.UIUtilities;
import orbital.util.InnerCheckedException;
import orbital.util.SuspiciousError;
import orbital.util.Utility;

public class DefaultCustomizer
extends JPanel
implements Customizer {
    private static final Logger logger = Logger.getLogger(DefaultCustomizer.class.getName());
    protected Class beanClass;
    protected PropertyDescriptor[] beanProperties;
    protected PropertyEditor[] propertyEditors;
    protected Component[] propertyEditorComponents;
    private Object bean = null;
    private int truncation = 30;
    private boolean spacing = false;
    private static final Comparator featureDescriptorComparator = new Comparator(){

        public int compare(Object a, Object b) {
            return ((FeatureDescriptor)a).getName().compareTo(((FeatureDescriptor)b).getName());
        }
    };
    private final PropertyChangeSupport propertyChangeListeners = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$java$awt$Frame;

    public DefaultCustomizer(Class beanClass) throws IntrospectionException {
        this.init(beanClass);
    }

    protected DefaultCustomizer() throws IntrospectionException {
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public int getTruncation() {
        return this.truncation;
    }

    public void setTruncation(int truncateAfter) {
        this.truncation = truncateAfter;
    }

    public void setSpacing(boolean value) {
        this.spacing = value;
    }

    public void setEnabled(boolean enabled) {
        logger.log(Level.FINEST, "DefaultCustomizer.setEnabled={0}", new Boolean(enabled));
        super.setEnabled(enabled);
        Component[] components = this.propertyEditorComponents;
        if (enabled) {
            for (int i = 0; i < components.length; ++i) {
                components[i].setEnabled(enabled && this.propertyEditors[i] != null && (this.propertyEditors[i].isPaintable() || this.propertyEditors[i].supportsCustomEditor() || this.beanProperties[i].getWriteMethod() != null));
            }
        } else {
            for (int i = 0; i < components.length; ++i) {
                components[i].setEnabled(enabled);
            }
        }
    }

    public void setEditable(boolean editable) {
        Boolean editableWrapped = editable ? Boolean.TRUE : Boolean.FALSE;
        logger.log(Level.FINEST, "DefaultCustomizer.setEditable={0}", editableWrapped);
        Component[] components = this.propertyEditorComponents;
        for (int i = 0; i < components.length; ++i) {
            Component c = DefaultCustomizer.unwrapComponent(components[i]);
            if (c instanceof JTextComponent) {
                try {
                    c.getClass().getMethod("setEditable", Boolean.TYPE).invoke((Object)c, editableWrapped);
                    continue;
                }
                catch (NoSuchMethodException noEditableChange) {
                }
                catch (SecurityException security) {
                }
                catch (IllegalAccessException inaccessible) {
                }
                catch (InvocationTargetException exception) {
                    throw new InnerCheckedException("Could not " + c.getClass() + ".setEditable(" + editable + ")", exception);
                }
            }
            logger.log(Level.FINEST, "searching for {0}.setEditable(boolean) was not successful", c.getClass());
            c.setEnabled(editable);
        }
    }

    private static final Component unwrapComponent(Component c) {
        while (true) {
            if (c instanceof InlinePaintablePropertyEditorComponent && ((InlinePaintablePropertyEditorComponent)c).customEditor != null) {
                c = ((InlinePaintablePropertyEditorComponent)c).customEditor;
                continue;
            }
            if (!(c instanceof JScrollPane)) break;
            c = ((JScrollPane)c).getViewport().getView();
        }
        return c;
    }

    protected void init(Class beanClass) throws IntrospectionException {
        this.beanClass = beanClass;
        BeanInfo info = this.getBeanInfo(beanClass);
        if (info == null) {
            throw new NullPointerException("no BeanInfo for class: " + beanClass);
        }
        this.beanProperties = this.getAllPropertyDescriptors(info);
        if (this.beanProperties == null) {
            throw new NullPointerException("no PropertyDescriptors for class: " + beanClass);
        }
        this.removeAll();
        this.setLayout(new GridBagLayout());
        GridBagConstraints l = new GridBagConstraints();
        l.anchor = 18;
        l.insets = new Insets(0, 0, 0, 12);
        GridBagConstraints r = new GridBagConstraints();
        r.gridwidth = 0;
        r.anchor = 18;
        r.fill = 1;
        r.weightx = 1.0;
        GridBagConstraints v = new GridBagConstraints();
        v.gridwidth = 0;
        v.anchor = 11;
        v.fill = 1;
        GridBagConstraints f = new GridBagConstraints();
        f.gridwidth = 0;
        f.anchor = 11;
        f.fill = 1;
        f.weighty = 0.5;
        this.propertyEditors = new PropertyEditor[this.beanProperties.length];
        this.propertyEditorComponents = new Component[this.beanProperties.length];
        for (int i = 0; i < this.beanProperties.length; ++i) {
            String displayName;
            if (this.beanProperties[i].isHidden()) {
                this.propertyEditors[i] = null;
                this.propertyEditorComponents[i] = null;
                continue;
            }
            if (this.spacing && i != 0) {
                Component verticalStrut = Box.createVerticalStrut(5);
                this.add(verticalStrut, v);
            }
            if ((displayName = this.beanProperties[i].getDisplayName()) != null && displayName.length() != 0 && displayName.charAt(displayName.length() - 1) != ':') {
                displayName = displayName + ":";
            }
            JLabel label = new JLabel(displayName);
            label.setToolTipText(this.beanProperties[i].getShortDescription());
            this.add((Component)label, l);
            this.propertyEditors[i] = DefaultCustomizer.getPropertyEditor(this.beanProperties[i]);
            this.propertyEditorComponents[i] = this.createPropertyEditorComponent(this.beanProperties[i], this.propertyEditors[i]);
            this.registerPropertyChangeUpdater(this.beanProperties[i], this.propertyEditors[i], this.propertyEditorComponents[i]);
            this.add(this.propertyEditorComponents[i], r);
            label.setLabelFor(this.propertyEditorComponents[i]);
        }
        if (this.spacing) {
            Component verticalGlue = Box.createVerticalGlue();
            this.add(verticalGlue, f);
        }
    }

    protected Component createPropertyEditorComponent(PropertyDescriptor property, PropertyEditor peditor) throws IntrospectionException {
        logger.log(Level.FINER, "property {1} of {0} has editor {2}", new Object[]{this.beanClass, UIUtilities.info(property), peditor});
        if (peditor == null) {
            JTextField editor = new JTextField();
            editor.setName(property.getName());
            editor.setEditable(false);
            return editor;
        }
        if (peditor.isPaintable() || peditor.supportsCustomEditor()) {
            if (peditor.supportsCustomEditor()) {
                Dimension dim = peditor.getCustomEditor().getPreferredSize();
                try {
                    if (((Boolean)peditor.getClass().getMethod("isInlineCustomEditor", null).invoke((Object)peditor, null)).booleanValue()) {
                        return new InlinePaintablePropertyEditorComponent(property, peditor);
                    }
                    return new ExteriorPaintablePropertyEditorComponent(property, peditor);
                }
                catch (NoSuchMethodException trial) {
                }
                catch (IllegalAccessException trial) {
                }
                catch (ClassCastException trial) {
                }
                catch (IllegalArgumentException imp) {
                }
                catch (InvocationTargetException ignore) {
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
                return dim.width <= 200 && dim.height <= 120 ? new InlinePaintablePropertyEditorComponent(property, peditor) : new ExteriorPaintablePropertyEditorComponent(property, peditor);
            }
            return new InlinePaintablePropertyEditorComponent(property, peditor);
        }
        if (peditor.getTags() != null) {
            String[] tags = peditor.getTags();
            JComboBox<String> editor = new JComboBox<String>();
            for (int i = 0; i < tags.length; ++i) {
                editor.addItem(tags[i]);
            }
            editor.setName(property.getName());
            if (property.getWriteMethod() != null) {
                editor.addActionListener(new PropertyEditingChange(peditor));
            } else {
                editor.setEnabled(false);
            }
            return editor;
        }
        JTextField editor = new JTextField();
        editor.setName(property.getName());
        if (property.getWriteMethod() != null) {
            editor.getDocument().addDocumentListener(new PropertyEditingChange(peditor));
        } else {
            editor.setEditable(false);
        }
        return editor;
    }

    protected void registerPropertyChangeUpdater(PropertyDescriptor property, PropertyEditor peditor, Component propertyEditorComponent) {
        if (peditor != null) {
            peditor.addPropertyChangeListener(new PropertyUpdater(property, peditor, propertyEditorComponent));
        }
    }

    protected static boolean customizerForProperty(PropertyDescriptor property) {
        try {
            BeanInfo info = Introspector.getBeanInfo(property.getPropertyType());
            if (info == null) {
                return false;
            }
            BeanDescriptor desc = info.getBeanDescriptor();
            if (desc == null) {
                return false;
            }
            return desc.getCustomizerClass() != null;
        }
        catch (IntrospectionException x) {
            return false;
        }
    }

    protected static PropertyEditor getPropertyEditor(PropertyDescriptor property) throws IntrospectionException {
        Class<?> propertyEditorClass = property.getPropertyEditorClass();
        if (propertyEditorClass == null) {
            if (property.getPropertyType() == null) {
                return null;
            }
            return PropertyEditorManager.findEditor(property.getPropertyType());
        }
        try {
            return (PropertyEditor)propertyEditorClass.newInstance();
        }
        catch (IllegalAccessException x) {
            throw new IntrospectionException("invalid property editor class" + x);
        }
        catch (InstantiationException x) {
            throw new IntrospectionException("invalid property editor class" + x);
        }
    }

    protected Object getObject() {
        return this.bean;
    }

    public void setObject(Object bean) {
        if (bean != null && !Beans.isInstanceOf(bean, this.beanClass)) {
            throw new IllegalArgumentException("instance initialized for another type: " + this.beanClass + ". Could not accept argument of type " + (bean != null ? bean.getClass().toString() : "null"));
        }
        try {
            this.bean = null;
            this.update(bean);
            this.bean = bean;
        }
        catch (IntrospectionException e) {
            throw new InnerCheckedException(e);
        }
        this.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(Object bean) throws IntrospectionException {
        try {
            for (int i = 0; i < this.beanProperties.length; ++i) {
                if (this.beanProperties[i].isHidden() || DefaultCustomizer.getReadMethod(this.beanProperties[i]) == null || this.beanProperties[i] instanceof IndexedPropertyDescriptor && this.beanProperties[i].getReadMethod() == null) continue;
                Object v = bean != null ? this.beanProperties[i].getReadMethod().invoke(bean, null) : null;
                PropertyEditor ped = this.propertyEditors[i];
                Component ed = this.propertyEditorComponents[i];
                if (ped == null) {
                    this.displaying(ed, v);
                    continue;
                }
                try {
                    ped.setValue(v);
                    if (ped.isPaintable() || ped.supportsCustomEditor()) continue;
                    if (ed instanceof JTextComponent || ed instanceof TextComponent) {
                        this.displaying(ed, ped.getAsText());
                        continue;
                    }
                    if (ed instanceof JComboBox) {
                        ((JComboBox)ed).setSelectedItem(ped.getAsText());
                        continue;
                    }
                    if (ed instanceof Choice) {
                        ((Choice)ed).select(ped.getAsText());
                        continue;
                    }
                    if (!(ed instanceof NumberInput)) {
                        throw new IllegalStateException("unsupported editor component " + ed + " for property " + this.beanProperties[i].getName());
                    }
                    ((NumberInput)ed).setValue((Number)ped.getValue());
                    continue;
                }
                catch (NullPointerException x) {
                    if (bean == null) continue;
                    throw x;
                }
                catch (IllegalArgumentException x) {
                    if (bean == null) continue;
                    throw x;
                }
            }
            return;
        }
        catch (InvocationTargetException ex) {
            throw (IntrospectionException)new IntrospectionException("nested " + ex + ": " + ex.getTargetException().getMessage()).initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (IntrospectionException)new IntrospectionException("nested " + ex).initCause(ex);
        }
    }

    private void displaying(Component ed, Object value) {
        String s;
        String string = s = value == null ? "<null>" : value.toString();
        if (ed instanceof TextComponent) {
            ((TextComponent)ed).setText(s);
            if (ed instanceof TextField) {
                TextField c = (TextField)ed;
                if (s.length() > this.truncation) {
                    c.setColumns(this.truncation);
                }
            }
        } else if (ed instanceof JTextComponent) {
            ((JTextComponent)ed).setText(s);
            if (ed instanceof JTextField) {
                JTextField c = (JTextField)ed;
                if (s.length() > this.truncation) {
                    c.setColumns(this.truncation);
                }
            }
        } else {
            throw new ClassCastException("illegal argument");
        }
    }

    private static Method getReadMethod(PropertyDescriptor property) {
        Method indexed;
        if (property instanceof IndexedPropertyDescriptor && (indexed = ((IndexedPropertyDescriptor)property).getIndexedReadMethod()) != null) {
            return indexed;
        }
        return property.getReadMethod();
    }

    protected BeanInfo getBeanInfo(Class cls) throws IntrospectionException {
        return Introspector.getBeanInfo(cls, 1);
    }

    protected PropertyDescriptor[] getAllPropertyDescriptors(BeanInfo info) {
        BeanInfo[] additional = info.getAdditionalBeanInfo();
        if (additional == null || additional.length == 0) {
            return info.getPropertyDescriptors();
        }
        TreeSet<PropertyDescriptor> l = new TreeSet<PropertyDescriptor>(featureDescriptorComparator);
        l.addAll(Arrays.asList(info.getPropertyDescriptors()));
        for (int i = additional.length - 1; i >= 0; --i) {
            PropertyDescriptor[] property = this.getAllPropertyDescriptors(additional[i]);
            if (property == null) continue;
            l.addAll(Arrays.asList(property));
        }
        return l.toArray(new PropertyDescriptor[0]);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.removePropertyChangeListener(listener);
    }

    private class ExteriorPaintablePropertyEditorComponent
    extends PropertyEditorComponent {
        public ExteriorPaintablePropertyEditorComponent(PropertyDescriptor property, PropertyEditor peditor) {
            super(peditor);
            if (peditor.supportsCustomEditor()) {
                this.addMouseListener(new MouseAdapter(this, DefaultCustomizer.this, peditor, property){
                    private final /* synthetic */ DefaultCustomizer val$this$0;
                    private final /* synthetic */ PropertyEditor val$peditor;
                    private final /* synthetic */ PropertyDescriptor val$property;
                    private final /* synthetic */ ExteriorPaintablePropertyEditorComponent this$1;
                    {
                        this.this$1 = this$1;
                        this.val$this$0 = val$this$0;
                        this.val$peditor = val$peditor;
                        this.val$property = val$property;
                    }

                    public void mouseClicked(MouseEvent e) {
                        if (DefaultCustomizer.access$100(ExteriorPaintablePropertyEditorComponent.access$400(this.this$1)) == null) {
                            return;
                        }
                        DefaultCustomizer.access$200().log(Level.FINEST, "exterior property editor component: open the custom editor that is supported");
                        new CustomizerViewController((Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = DefaultCustomizer.class$("java.awt.Frame")) : class$java$awt$Frame, ExteriorPaintablePropertyEditorComponent.access$400(this.this$1))).showCustomizer(this.val$peditor.getCustomEditor(), this.val$property.getDisplayName());
                    }
                });
            }
            logger.log(Level.FINER, "exterior property editor component: create exterior property editor component for {0} {1} custom editor support", new Object[]{property, peditor.supportsCustomEditor() ? "with" : "without"});
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
        }

        static /* synthetic */ DefaultCustomizer access$400(ExteriorPaintablePropertyEditorComponent x0) {
            return x0.DefaultCustomizer.this;
        }
    }

    private class InlinePaintablePropertyEditorComponent
    extends PropertyEditorComponent {
        private final Component customEditor;

        public InlinePaintablePropertyEditorComponent(PropertyDescriptor property, PropertyEditor peditor) {
            super(peditor);
            Component component = this.customEditor = peditor.supportsCustomEditor() ? peditor.getCustomEditor() : null;
            if (this.customEditor != null) {
                this.add(this.customEditor, "Center");
            }
            logger.log(Level.FINER, "inline property editor component: create inline property editor component for {0} with visual content {1}", new Object[]{property, this.customEditor});
        }

        public Dimension getMinimumSize() {
            return this.customEditor != null ? this.customEditor.getMinimumSize() : super.getMinimumSize();
        }

        public Dimension getPreferredSize() {
            return this.customEditor != null ? this.customEditor.getPreferredSize() : super.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.customEditor != null ? this.customEditor.getMaximumSize() : super.getMaximumSize();
        }

        public void paintComponent(Graphics g) {
            if (this.customEditor != null) {
                super.paintSuperComponent(g);
            } else {
                super.paintComponent(g);
            }
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.customEditor != null) {
                this.customEditor.setEnabled(enabled);
            }
        }
    }

    private class PropertyEditorComponent
    extends JPanel {
        protected PropertyEditor peditor;

        public PropertyEditorComponent(PropertyEditor peditor) {
            this.peditor = peditor;
            this.setLayout(new BorderLayout());
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d = this.getSize();
            if (this.peditor.isPaintable()) {
                this.peditor.paintValue(g, new Rectangle(d));
            } else {
                g.drawString(this.peditor.getValue() == null ? "<null>" : "...", 0, d.height * 4 / 5);
            }
        }

        void paintSuperComponent(Graphics g) {
            super.paintComponent(g);
        }

        public void setEnabled(boolean enabled) {
            logger.log(Level.FINEST, "PropertyEditorComponent.setEnabled={0}", new Boolean(enabled));
            boolean oldEnabled = this.isEnabled();
            super.setEnabled(enabled);
            if (enabled != oldEnabled) {
                this.setForeground(enabled ? SystemColor.textText : SystemColor.textInactiveText);
                this.setBackground(enabled ? SystemColor.control : SystemColor.text);
            }
        }
    }

    private class PropertyEditingChange
    implements ActionListener,
    ItemListener,
    DocumentListener,
    InputMethodListener,
    TextListener {
        protected PropertyEditor peditor;

        public PropertyEditingChange(PropertyEditor peditor) {
            this.peditor = peditor;
        }

        public void actionPerformed(ActionEvent e) {
            if (DefaultCustomizer.this.bean == null) {
                return;
            }
            try {
                Object source = e.getSource();
                if (!(source instanceof JComboBox)) {
                    throw new ClassCastException("illegal event source type " + source.getClass());
                }
                String v = (String)((JComboBox)e.getSource()).getSelectedItem();
                this.peditor.setAsText(v);
            }
            catch (IllegalArgumentException cause) {
                logger.log(Level.WARNING, "illegal value", cause);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (DefaultCustomizer.this.bean == null) {
                return;
            }
            if (e.getStateChange() != 1) {
                return;
            }
            try {
                String v = "" + e.getItem();
                this.peditor.setAsText(v);
            }
            catch (IllegalArgumentException cause) {
                logger.log(Level.WARNING, "illegal value", cause);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.documentUpdate(e);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private void documentUpdate(DocumentEvent e) {
            if (DefaultCustomizer.this.bean == null) {
                return;
            }
            String v = null;
            try {
                Document doc = e.getDocument();
                v = doc.getText(0, doc.getLength());
                this.peditor.setAsText(v);
            }
            catch (BadLocationException imp) {
                throw new SuspiciousError("strange document. " + imp);
            }
            catch (NumberFormatException cause) {
                if (v != null && v.length() == 0) {
                    return;
                }
                logger.log(Level.WARNING, "illegal value", cause.getMessage());
            }
            catch (IllegalArgumentException cause) {
                logger.log(Level.WARNING, "illegal value", cause);
            }
        }

        public void inputMethodTextChanged(InputMethodEvent e) {
            if (DefaultCustomizer.this.bean == null) {
                return;
            }
            try {
                String v = ((JTextComponent)e.getSource()).getText();
                this.peditor.setAsText(v);
            }
            catch (IllegalArgumentException cause) {
                logger.log(Level.WARNING, "illegal value", cause);
            }
        }

        public void caretPositionChanged(InputMethodEvent event) {
        }

        public void textValueChanged(TextEvent e) {
            if (DefaultCustomizer.this.bean == null) {
                return;
            }
            try {
                String v = ((TextComponent)e.getSource()).getText();
                this.peditor.setAsText(v);
            }
            catch (IllegalArgumentException cause) {
                logger.log(Level.WARNING, "illegal value", cause);
            }
        }
    }

    private class PropertyUpdater
    implements PropertyChangeListener {
        protected PropertyDescriptor property;
        protected PropertyEditor peditor;
        protected Component propertyEditorComponent;

        public PropertyUpdater(PropertyDescriptor property, PropertyEditor peditor, Component propertyEditorComponent) {
            this.property = property;
            this.peditor = peditor;
            this.propertyEditorComponent = propertyEditorComponent;
        }

        public void propertyChange(PropertyChangeEvent e) {
            try {
                if (DefaultCustomizer.this.bean == null) {
                    return;
                }
                logger.log(Level.FINER, "change event {0} from \"{1}\" to \"{2}\", via {3}", new Object[]{this.property.getName(), e.getOldValue(), e.getNewValue(), e});
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                boolean allChanged = oldValue == null && newValue == null;
                PropertyEditor ped = this.peditor != null ? this.peditor : (PropertyEditor)e.getSource();
                Object oldFromBean = this.property.getReadMethod().invoke(DefaultCustomizer.this.bean, null);
                Object newFromPed = ped.getValue();
                logger.log(Level.FINEST, "change verify that old value fired ({0}) equals current value of bean ({2})\nnew value fired ({1}) equals value of property editor ({3})", new Object[]{oldValue, newValue, oldFromBean, newFromPed});
                if (allChanged) {
                    oldValue = oldFromBean;
                    newValue = newFromPed;
                } else if (Utility.equals(newValue, oldValue)) {
                    if (Utility.equals(newFromPed, oldFromBean)) {
                        return;
                    }
                    oldValue = oldFromBean;
                    newValue = newFromPed;
                }
                this.property.getWriteMethod().invoke(DefaultCustomizer.this.bean, newValue);
                DefaultCustomizer.this.propertyChangeListeners.firePropertyChange(this.property.getName(), oldValue, newValue);
                logger.log(Level.FINER, "changed {0} from \"{1}\" to \"{2}\", via {3}", new Object[]{this.property.getName(), oldValue, newValue, e});
                if (this.propertyEditorComponent != null && this.peditor.isPaintable()) {
                    this.propertyEditorComponent.repaint();
                }
            }
            catch (InvocationTargetException x) {
                try {
                    throw x.getTargetException();
                }
                catch (PropertyVetoException cause) {
                    logger.log(Level.WARNING, "illegal value", cause);
                    JOptionPane.showMessageDialog(DefaultCustomizer.this, cause.getMessage(), "value rejected", 0);
                }
                catch (IllegalArgumentException cause) {
                    logger.log(Level.WARNING, "illegal value", cause);
                    JOptionPane.showMessageDialog(DefaultCustomizer.this, cause.getMessage(), "illegal value", 0);
                }
                catch (NullPointerException cause) {
                    logger.log(Level.WARNING, "illegal value", cause);
                    JOptionPane.showMessageDialog(DefaultCustomizer.this, "null value " + cause.getMessage(), "illegal value", 0);
                }
                catch (Throwable rethrow) {
                    throw new InnerCheckedException(rethrow);
                }
            }
            catch (IllegalAccessException ex) {
                throw new InnerCheckedException(ex);
            }
            catch (IllegalArgumentException cause) {
                logger.log(Level.WARNING, "illegal value", cause);
            }
        }
    }
}

