/*
 * Decompiled with CFR 0.152.
 */
package orbital.math.functional;

import orbital.logic.functor.Predicate;
import orbital.logic.functor.VoidFunction;
import orbital.logic.trs.Variable;
import orbital.math.Arithmetic;
import orbital.math.Complex;
import orbital.math.Matrix;
import orbital.math.Normed;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Symbol;
import orbital.math.UnivariatePolynomial;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.AbstractBinaryFunction;
import orbital.math.functional.AbstractFunction;
import orbital.math.functional.BinaryFunction;
import orbital.math.functional.Function;
import orbital.math.functional.Functionals;
import orbital.math.functional.MathFunctor;
import orbital.math.functional.Operations;
import orbital.math.functional.SynonymFunction;
import orbital.moon.math.functional.AbstractFunctor;
import orbital.util.Utility;

public final class Functions {
    public static final Functions functions = new Functions();
    private static final Values valueFactory = Values.getDefaultInstance();
    private static final Scalar TWO = valueFactory.valueOf(2);
    public static final Function zero = Functions.constant(valueFactory.valueOf(0));
    public static final Function one = Functions.constant(valueFactory.valueOf(1));
    public static final Function id = new AbstractFunction(){

        public Object apply(Object x) {
            return x;
        }

        public Function derive() {
            return one;
        }

        public Function integrate() {
            return (Function)Operations.divide.apply(square, TWO);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "id";
        }
    };
    public static final Function reciprocal = Operations.inverse;
    public static final Function square = new SynonymFunction(Functions.pow(TWO)){

        public Object apply(Object x) {
            if (Complex.hasType.apply(x)) {
                Complex v = (Complex)x;
                return v.multiply(v);
            }
            if (x instanceof Number) {
                double v = ((Number)x).doubleValue();
                return valueFactory.valueOf(v * v);
            }
            Arithmetic v = (Arithmetic)x;
            return v.multiply(v);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "#0^2";
        }
    };
    public static final Function sqrt = new SynonymFunction(Functions.pow(valueFactory.valueOf(0.5))){

        public Object apply(Object x) {
            if (Complex.hasType.apply(x)) {
                Complex v = (Complex)x;
                return valueFactory.polar((Real)this.apply(v.norm()), v.arg().divide(valueFactory.valueOf(2)));
            }
            if (x instanceof Number) {
                double r = ((Number)x).doubleValue();
                if (r != r) {
                    return Values.NaN;
                }
                return r >= 0.0 ? valueFactory.valueOf(Math.sqrt(r)) : this.apply(valueFactory.cartesian(r, 0.0));
            }
            return (Complex)super.apply(x);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "sqrt";
        }
    };
    public static final Function exp = new AbstractFunction(){

        public Object apply(Object x) {
            if (Complex.hasType.apply(x)) {
                Complex z = (Complex)x;
                return valueFactory.polar((Real)this.apply(z.re()), z.im());
            }
            if (x instanceof Number) {
                return valueFactory.valueOf(Math.exp(((Number)x).doubleValue()));
            }
            if (x instanceof Matrix) {
                throw new UnsupportedOperationException("not yet implemented - limit or at least jordan normalization required for " + x.getClass());
            }
            if (x instanceof Symbol) {
                return valueFactory.symbol("e").power((Arithmetic)x);
            }
            return Functionals.genericCompose(this, x);
        }

        public Function derive() {
            return this;
        }

        public Function integrate() {
            return this;
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "exp";
        }
    };
    public static final Function log = new AbstractFunction(){

        public Object apply(Object x) {
            if (Complex.hasType.apply(x)) {
                Complex v = (Complex)x;
                return valueFactory.cartesian((Real)this.apply(v.norm()), v.arg());
            }
            if (x instanceof Number) {
                double r = ((Number)x).doubleValue();
                return r >= 0.0 ? valueFactory.valueOf(Math.log(r)) : this.apply(valueFactory.cartesian(r, 0.0));
            }
            if (x instanceof Matrix) {
                throw new UnsupportedOperationException("not yet implemented - something like limit required for " + x.getClass());
            }
            return Functionals.genericCompose(this, x);
        }

        public Function derive() {
            return reciprocal;
        }

        public Function integrate() {
            return (Function)Operations.subtract.apply(Operations.times.apply(id, Functionals.compose(this, norm)), id);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "log";
        }
    };
    public static final Function sin = new AbstractFunction(){

        public Object apply(Object x) {
            if (Complex.hasType.apply(x)) {
                return ((Arithmetic)sinh.apply(Values.i.multiply((Arithmetic)x))).divide(Values.i);
            }
            if (x instanceof Number) {
                return valueFactory.valueOf(Math.sin(((Number)x).doubleValue()));
            }
            throw new UnsupportedOperationException("not implemented for type: " + x.getClass());
        }

        public Function derive() {
            return cos;
        }

        public Function integrate() {
            return Functionals.compose(Operations.minus, cos);
        }

        public Real norm() {
            return Values.ONE;
        }

        public String toString() {
            return "sin";
        }
    };
    public static final Function cos = new AbstractFunction(){

        public Object apply(Object x) {
            if (Complex.hasType.apply(x)) {
                return cosh.apply(Values.i.multiply((Arithmetic)x));
            }
            if (x instanceof Number) {
                return valueFactory.valueOf(Math.cos(((Number)x).doubleValue()));
            }
            throw new UnsupportedOperationException("not implemented for type: " + x.getClass());
        }

        public Function derive() {
            return Functionals.compose(Operations.minus, sin);
        }

        public Function integrate() {
            return sin;
        }

        public Real norm() {
            return Values.ONE;
        }

        public String toString() {
            return "cos";
        }
    };
    public static final Function tan = new SynonymFunction(Functionals.compose(Operations.divide, sin, cos)){

        public Object apply(Object x) {
            if (x instanceof Number && !Complex.hasType.apply(x)) {
                return valueFactory.valueOf(Math.tan(((Number)x).doubleValue()));
            }
            return super.apply(x);
        }

        public Function derive() {
            return Functionals.compose(Functions.pow(TWO), sec);
        }

        public Function integrate() {
            return Functionals.compose(Operations.minus, Functionals.compose(log, cos));
        }

        public String toString() {
            return "tan";
        }
    };
    public static final Function cot = new SynonymFunction(Functionals.compose(Operations.divide, cos, sin)){

        public Object apply(Object x) {
            return ((Arithmetic)tan.apply(x)).inverse();
        }

        public Function derive() {
            return (Function)Operations.minus.apply(Functions.pow(TWO).apply(csc));
        }

        public Function integrate() {
            return Functionals.compose(log, sin);
        }

        public String toString() {
            return "cot";
        }
    };
    public static final Function csc = new SynonymFunction(Functionals.compose(Operations.inverse, sin)){

        public Function derive() {
            return (Function)Operations.times.apply(Operations.minus.apply(cot), csc);
        }

        public String toString() {
            return "csc(x)";
        }
    };
    public static final Function sec = new SynonymFunction(Functionals.compose(Operations.inverse, cos)){

        public Function derive() {
            return (Function)Operations.times.apply(sec, tan);
        }

        public String toString() {
            return "sec";
        }
    };
    public static final Function arcsin = new AbstractFunction(){

        public Object apply(Object x) {
            if (x instanceof Number) {
                return Values.getDefaultInstance().valueOf(Math.asin(((Number)x).doubleValue()));
            }
            throw new UnsupportedOperationException("not implemented for type: " + x.getClass());
        }

        public Function derive() {
            return (Function)Functionals.compose(sqrt, Functionals.compose(Operations.subtract, one, square)).inverse();
        }

        public Function integrate() {
            return (Function)Operations.plus.apply(Operations.times.apply(id, this), Functionals.compose(sqrt, Functionals.compose(Operations.subtract, one, square)));
        }

        public Real norm() {
            return valueFactory.valueOf(1.5707963267948966);
        }

        public String toString() {
            return "arcsin";
        }
    };
    public static final Function arccos = new AbstractFunction(){

        public Object apply(Object x) {
            if (x instanceof Number) {
                return valueFactory.valueOf(Math.acos(((Number)x).doubleValue()));
            }
            throw new UnsupportedOperationException("not implemented for type: " + x.getClass());
        }

        public Function derive() {
            return (Function)Functionals.compose(sqrt, Functionals.compose(Operations.subtract, one, square)).inverse().minus();
        }

        public Function integrate() {
            return (Function)Operations.subtract.apply(Operations.times.apply(id, this), Functionals.compose(sqrt, Functionals.compose(Operations.subtract, one, square)));
        }

        public Real norm() {
            return Values.PI;
        }

        public String toString() {
            return "arccos";
        }
    };
    public static final Function arctan = new AbstractFunction(){

        public Object apply(Object x) {
            if (x instanceof Number) {
                return valueFactory.valueOf(Math.atan(((Number)x).doubleValue()));
            }
            throw new UnsupportedOperationException("not implemented for type: " + x.getClass());
        }

        public Function derive() {
            return (Function)Functionals.compose(Operations.plus, one, square).inverse();
        }

        public Function integrate() {
            return (Function)Operations.subtract.apply(Operations.times.apply(id, this), Functionals.compose(log, Functionals.compose(Operations.plus, square, one)).divide(TWO));
        }

        public Real norm() {
            return valueFactory.valueOf(1.5707963267948966);
        }

        public String toString() {
            return "arctan";
        }
    };
    public static final Function arccot = new AbstractFunction(){
        private final double PI_HALF = 1.5707963267948966;

        public Object apply(Object x) {
            if (x instanceof Number) {
                return valueFactory.valueOf(1.5707963267948966 - Math.atan(((Number)x).doubleValue()));
            }
            throw new UnsupportedOperationException("not implemented for type: " + x.getClass());
        }

        public Function derive() {
            return (Function)Functionals.compose(Operations.plus, one, square).inverse().minus();
        }

        public Function integrate() {
            return (Function)Operations.plus.apply(Operations.times.apply(id, this), Functionals.compose(log, Functionals.compose(Operations.plus, square, one)).divide(TWO));
        }

        public Real norm() {
            return Values.PI;
        }

        public String toString() {
            return "arccot";
        }
    };
    public static final Function sinh = new AbstractFunction(){

        public Object apply(Object z) {
            if (z instanceof Arithmetic) {
                Arithmetic ez = (Arithmetic)exp.apply(z);
                return ez.subtract(ez.inverse()).divide(TWO);
            }
            throw new UnsupportedOperationException("not implemented for type: " + z.getClass());
        }

        public Function derive() {
            return cosh;
        }

        public Function integrate() {
            return cosh;
        }

        public String toString() {
            return "sinh";
        }
    };
    public static final Function cosh = new AbstractFunction(){

        public Object apply(Object z) {
            if (z instanceof Arithmetic) {
                Arithmetic ez = (Arithmetic)exp.apply(z);
                return ez.add(ez.inverse()).divide(TWO);
            }
            throw new UnsupportedOperationException("not implemented for type: " + z.getClass());
        }

        public Function derive() {
            return sinh;
        }

        public Function integrate() {
            return sinh;
        }

        public String toString() {
            return "cosh";
        }
    };
    public static final Function tanh = new SynonymFunction(Functionals.compose(Operations.divide, sinh, cosh)){

        public Object apply(Object x) {
            Arithmetic ex = (Arithmetic)exp.apply(x);
            Arithmetic e_x = ex.inverse();
            return ex.subtract(e_x).divide(ex.add(e_x));
        }

        public Function derive() {
            return Functionals.compose(Functions.pow(TWO), sech);
        }

        public Function integrate() {
            return Functionals.compose(log, cosh);
        }

        public String toString() {
            return "tanh(x)";
        }
    };
    public static final Function csch = new SynonymFunction(Functionals.compose(Operations.inverse, sinh)){

        public Function derive() {
            return (Function)Operations.times.apply(Operations.minus.apply(coth), csch);
        }

        public String toString() {
            return "csch";
        }
    };
    public static final Function sech = new SynonymFunction(Functionals.compose(Operations.inverse, cosh)){

        public Function derive() {
            return (Function)Operations.times.apply(Operations.minus.apply(sech), tanh);
        }

        public String toString() {
            return "sech";
        }
    };
    public static final Function coth = new SynonymFunction(Functionals.compose(Operations.divide, cosh, sinh)){

        public Object apply(Object x) {
            return ((Arithmetic)tanh.apply(x)).inverse();
        }

        public Function derive() {
            return (Function)Operations.minus.apply(Functions.pow(TWO).apply(csch));
        }

        public Function integrate() {
            return Functionals.compose(log, sinh);
        }

        public String toString() {
            return "coth";
        }
    };
    public static final Function arsinh = new SynonymFunction(Functionals.compose(log, (Function)Operations.plus.apply(id, Functionals.compose(sqrt, Functionals.compose(Operations.plus, square, one))))){

        public Function derive() {
            return (Function)Functionals.compose(sqrt, Functionals.compose(Operations.plus, square, one)).inverse();
        }

        public Function integrate() {
            return (Function)Operations.subtract.apply(Operations.times.apply(id, this), Functionals.compose(sqrt, Functionals.compose(Operations.plus, square, one)));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "arsinh";
        }
    };
    public static final Function arcosh = new SynonymFunction(Functionals.compose(log, (Function)Operations.plus.apply(id, Functionals.compose(sqrt, Functionals.compose(Operations.subtract, square, one))))){

        public Function derive() {
            return (Function)Functionals.compose(sqrt, Functionals.compose(Operations.subtract, square, one)).inverse();
        }

        public Function integrate() {
            return (Function)Operations.subtract.apply(Operations.times.apply(id, this), Functionals.compose(sqrt, Functionals.compose(Operations.subtract, square, one)));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "arcosh";
        }
    };
    public static final Function artanh = new SynonymFunction((Function)Operations.divide.apply(Functionals.compose(log, (Function)Operations.divide.apply(Functionals.bindFirst(Operations.plus, (Object)Values.ONE), Functionals.bindFirst(Operations.subtract, (Object)Values.ONE))), TWO)){

        public Object apply(Object x) {
            if (x instanceof Arithmetic) {
                Arithmetic v = (Arithmetic)x;
                return ((Arithmetic)log.apply(Values.ONE.add(v).divide(Values.ONE.subtract(v)))).divide(TWO);
            }
            throw new UnsupportedOperationException("not implemented for type: " + x.getClass());
        }

        public Function derive() {
            return (Function)Functionals.compose(Operations.subtract, one, square).inverse();
        }

        public Function integrate() {
            return (Function)Operations.plus.apply(Operations.times.apply(id, this), Functionals.compose(log, Functionals.compose(Operations.subtract, square, one)).divide(TWO));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "artanh";
        }
    };
    public static final Function arcoth = new SynonymFunction(new SynonymFunction((Function)Operations.divide.apply(Functionals.compose(log, (Function)Operations.divide.apply(Functionals.bindSecond(Operations.plus, (Object)Values.ONE), Functionals.bindSecond(Operations.subtract, (Object)Values.ONE))), TWO))){

        public Object apply(Object x) {
            if (x instanceof Arithmetic) {
                Arithmetic v = (Arithmetic)x;
                return ((Arithmetic)log.apply(v.add(Values.ONE).divide(v.subtract(Values.ONE)))).divide(TWO);
            }
            throw new UnsupportedOperationException("not implemented for type: " + x.getClass());
        }

        public Function derive() {
            return (Function)Functionals.compose(Operations.subtract, one, square).inverse();
        }

        public Function integrate() {
            return (Function)Operations.plus.apply(Operations.times.apply(id, this), Functionals.compose(log, Functionals.compose(Operations.subtract, square, one)).divide(TWO));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "arcoth";
        }
    };
    public static final Function norm = new AbstractFunction(){

        public Object apply(Object x) {
            if (x instanceof Symbol) {
                return Functionals.genericCompose(this, x);
            }
            return ((Normed)x).norm();
        }

        public Function derive() {
            return (Function)Operations.divide.apply(id, norm);
        }

        public Function integrate() {
            throw new UnsupportedOperationException("integrate " + this);
        }

        public Real norm() {
            throw new UnsupportedOperationException("||" + this + "||");
        }

        public String toString() {
            return "||#0||";
        }
    };
    public static final Function nondet = new AbstractFunction(){

        public Object apply(Object x) {
            return Math.random() >= 0.5 ? x : ((Arithmetic)x).minus();
        }

        public Function derive() {
            return nondet;
        }

        public Function integrate() {
            return nondet;
        }

        public Real norm() {
            return Values.NaN;
        }

        public String toString() {
            return "nondet";
        }
    };
    public static final Function logistic = new SynonymFunction((Function)((Function)Operations.plus.apply(valueFactory.valueOf(1), Functionals.compose(exp, Operations.minus))).inverse()){

        public Function derive() {
            Function emx = Functionals.compose(exp, Operations.minus);
            return (Function)emx.divide(Functionals.compose(square, (Function)Operations.plus.apply(valueFactory.valueOf(1), emx)));
        }

        public Real norm() {
            return Values.ONE;
        }

        public String toString() {
            return "logistic";
        }
    };
    public static final Function sign = new AbstractFunction(){

        public Object apply(Object x) {
            if (Real.hasType.apply(x)) {
                Real z = (Real)x;
                Real abs = z.norm();
                return abs.equals(Values.ZERO) ? Values.ZERO : z.divide(abs);
            }
            int cmp = Values.ZERO.compareTo(x);
            return valueFactory.valueOf(cmp < 0 ? -1 : (cmp > 0 ? 1 : 0));
        }

        public Function derive() {
            return diracDelta;
        }

        public Function integrate() {
            throw new UnsupportedOperationException("integrate " + this);
        }

        public Real norm() {
            return Values.ONE;
        }

        public String toString() {
            return "sign";
        }
    };
    public static final Function diracDelta = new AbstractFunction(){

        public Object apply(Object x) {
            if (((Normed)x).norm().equals(Values.ZERO)) {
                throw new IllegalArgumentException(x + "");
            }
            return Values.ZERO;
        }

        public Function derive() {
            return diracDelta;
        }

        public Function integrate() {
            return Functions.step(Values.ZERO);
        }

        public Real norm() {
            return Values.NaN;
        }

        public String toString() {
            return "diracDelta";
        }
    };
    static final BinaryFunction binaryzero = Functions.binaryConstant(valueFactory.valueOf(0));
    static final BinaryFunction binaryone = Functions.binaryConstant(valueFactory.valueOf(1));
    public static final BinaryFunction projectFirst = new AbstractBinaryFunction(){

        public Object apply(Object first, Object second) {
            return first;
        }

        public BinaryFunction derive() {
            return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{binaryone, binaryzero}}));
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            return i == 0 ? Functionals.onFirst(id.integrate()) : binaryzero;
        }

        public String toString() {
            return "#0";
        }
    };
    public static BinaryFunction projectSecond = new AbstractBinaryFunction(){

        public Object apply(Object first, Object second) {
            return second;
        }

        public BinaryFunction derive() {
            return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{binaryzero, binaryone}}));
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            return i == 0 ? binaryzero : Functionals.onSecond(id.integrate());
        }

        public String toString() {
            return "#1";
        }
    };
    public static final BinaryFunction delta = new AbstractBinaryFunction(){

        public Object apply(Object x, Object y) {
            return valueFactory.valueOf(x.equals(y) ? 1 : 0);
        }

        public BinaryFunction derive() {
            throw new UnsupportedOperationException("delta'");
        }

        public BinaryFunction integrate(int i) {
            throw new UnsupportedOperationException("integrate delta");
        }

        public Real norm() {
            return Values.ONE;
        }

        public String toString() {
            return "delta";
        }
    };

    private Functions() {
    }

    public static final Function constant(Object a) {
        return new ConstantFunction(a);
    }

    public static final Function symbolic(String name) {
        return new SymbolicFunction(name);
    }

    public static final Function linear(final Arithmetic a) {
        return new AbstractFunction(){

            public Object apply(Object x) {
                return a.multiply((Arithmetic)x);
            }

            public Function derive() {
                return Functions.constant(a);
            }

            public Function integrate() {
                return (Function)Operations.times.apply(Operations.divide.apply(a, TWO), square);
            }

            public String toString() {
                return a + "*#0";
            }
        };
    }

    public static final Function pow(Arithmetic p) {
        return Functionals.bindSecond(Operations.power, (Object)p);
    }

    public static final Function pow(double p) {
        return Functions.pow(valueFactory.valueOf(p));
    }

    public static final Function exp(Arithmetic b) {
        return Functionals.bindFirst(Operations.power, (Object)b);
    }

    public static final Function projection(final int component) {
        return new AbstractFunction(){

            public Object apply(Object x) {
                return ((Vector)x).get(component);
            }

            public Function derive() {
                throw new UnsupportedOperationException(this + "'");
            }

            public Function integrate() {
                throw new UnsupportedOperationException("integrate " + this);
            }

            public String toString() {
                return "pi" + component;
            }
        };
    }

    public static final Function projection(final int i, final int j) {
        return new AbstractFunction(){

            public Object apply(Object x) {
                return ((Matrix)x).get(i, j);
            }

            public Function derive() {
                throw new UnsupportedOperationException(this + "'");
            }

            public Function integrate() {
                throw new UnsupportedOperationException("integrate " + this);
            }

            public String toString() {
                return "pi" + i + "_" + j;
            }
        };
    }

    public static final UnivariatePolynomial polynom(int degree) {
        return Functions.polynom(valueFactory.IDENTITY(degree, degree).getDiagonal());
    }

    public static final UnivariatePolynomial polynom(Vector coeff) {
        return valueFactory.asPolynomial(coeff);
    }

    public static final Function step(final Real t) {
        return new AbstractFunction(){

            public Object apply(Object x) {
                return valueFactory.valueOf(t.compareTo(x) < 0 ? 0 : 1);
            }

            public Function derive() {
                return Functionals.compose(diracDelta, Functionals.bindFirst(Operations.subtract, (Object)t));
            }

            public Function integrate() {
                return (Function)Operations.times.apply(Functions.step(t), Functionals.bindSecond(Operations.subtract, (Object)t));
            }

            public Real norm() {
                return Values.ONE;
            }

            public String toString() {
                return "step_" + t;
            }
        };
    }

    public static final Function piecewise(final Predicate[] cond, final Function[] value) {
        Utility.pre(cond.length == value.length, "same number of conditions and values");
        return new AbstractFunction(){

            private int getIndexOfFirstTrue(Object x) {
                for (int j = 0; j < cond.length; ++j) {
                    if (!cond[j].apply(x)) continue;
                    return j;
                }
                throw new IllegalArgumentException("piecewise function undefined at " + x + " since no predicate is true");
            }

            public Object apply(Object x) {
                return value[this.getIndexOfFirstTrue(x)].apply(x);
            }

            public Function derive() throws ArithmeticException {
                Function[] di = new Function[value.length];
                for (int i = 0; i < di.length; ++i) {
                    di[i] = value[i].derive();
                }
                return Functions.piecewise(cond, di);
            }

            public Function integrate() throws ArithmeticException {
                Function[] di = new Function[value.length];
                for (int i = 0; i < di.length; ++i) {
                    di[i] = value[i].integrate();
                }
                return Functions.piecewise(cond, di);
            }

            public Real norm() {
                return (Real)Functionals.foldRight((orbital.logic.functor.BinaryFunction)Operations.max, (Object)value[0].norm(), Functionals.map((orbital.logic.functor.Function)norm, value));
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < cond.length; ++i) {
                    sb.append((i > 0 ? ", " : "") + cond[i] + " => " + value[i]);
                }
                return "piecewise [" + sb.toString() + "]";
            }
        };
    }

    public static final BinaryFunction binaryConstant(Object a) {
        return new BinaryConstantFunction(a);
    }

    public static final BinaryFunction binarySymbolic(String name) {
        return new BinarySymbolicFunction(name);
    }

    public static final int delta(int i, int j) {
        return i == j ? 1 : 0;
    }

    static class PointwiseBinaryFunction
    extends AbstractFunctor
    implements BinaryFunction {
        private final BinaryFunction elemental;

        public PointwiseBinaryFunction(BinaryFunction elemental) {
            this.elemental = elemental;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PointwiseBinaryFunction)) {
                return false;
            }
            return this.elemental.equals(((PointwiseBinaryFunction)o).elemental);
        }

        public int hashCode() {
            return this.elemental.hashCode();
        }

        public Object apply(Object x, Object y) {
            if (x instanceof Arithmetic && !(x instanceof MathFunctor) && y instanceof Arithmetic && !(y instanceof MathFunctor)) {
                return this.elemental.apply(x, y);
            }
            return Functionals.genericCompose(this, x, y);
        }

        public BinaryFunction derive() {
            return this.elemental.derive();
        }

        public BinaryFunction integrate(int i) {
            return this.elemental.integrate(i);
        }

        public String toString() {
            return this.elemental.toString();
        }
    }

    private static final class BinarySymbolicFunction
    extends AbstractBinaryFunction {
        private String name;

        public BinarySymbolicFunction(String name) {
            this.name = name;
        }

        public Object apply(Object x, Object y) {
            return Functionals.genericCompose(this, x, y);
        }

        public BinaryFunction derive() {
            return Functions.binarySymbolic(this.name + "'");
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            return Functions.binarySymbolic("\u222b" + this.name + " d" + (i == 0 ? (char)'x' : 'y'));
        }

        public Real norm() {
            return Values.NaN;
        }

        public boolean equals(Object o) {
            return o instanceof BinarySymbolicFunction && Utility.equals(this.name, ((BinarySymbolicFunction)o).name);
        }

        public int hashCode() {
            return Utility.hashCode(this.name);
        }

        public String toString() {
            return this.name + "";
        }
    }

    static final class BinaryConstantFunction
    extends AbstractBinaryFunction
    implements VoidFunction {
        Object a;

        public BinaryConstantFunction(Object a) {
            this.a = a;
        }

        public Object apply() {
            return this.a;
        }

        public Object apply(Object x, Object y) {
            return this.apply();
        }

        public BinaryFunction derive() {
            return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{binaryzero, binaryzero}}));
        }

        public BinaryFunction integrate(int i) {
            return Functionals.on(i, Functions.linear((Arithmetic)this.a));
        }

        public Real norm() {
            return ((Normed)this.a).norm();
        }

        public boolean equals(Object o) {
            return o instanceof BinaryConstantFunction && Utility.equals(this.a, ((BinaryConstantFunction)o).a);
        }

        public int hashCode() {
            return Utility.hashCode(this.a);
        }

        public String toString() {
            return this.a + "";
        }
    }

    static class PointwiseFunction
    extends AbstractFunctor
    implements Function {
        private final Function elemental;

        public PointwiseFunction(Function elemental) {
            this.elemental = elemental;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PointwiseFunction)) {
                return false;
            }
            return this.elemental.equals(((PointwiseFunction)o).elemental);
        }

        public int hashCode() {
            return this.elemental.hashCode();
        }

        public Object apply(Object x) {
            if (x instanceof Arithmetic && !(x instanceof MathFunctor)) {
                return this.elemental.apply(x);
            }
            return Functionals.genericCompose(this, x);
        }

        public Function derive() {
            return this.elemental.derive();
        }

        public Function integrate() {
            return this.elemental.integrate();
        }

        public String toString() {
            return this.elemental.toString();
        }
    }

    private static final class SymbolicFunction
    extends AbstractFunction {
        private String name;

        public SymbolicFunction(String name) {
            this.name = name;
        }

        public Object apply(Object x) {
            return Functionals.genericCompose(this, x);
        }

        public Function derive() {
            return Functions.symbolic(this.name + "'");
        }

        public Function integrate() {
            return Functions.symbolic("\u222b" + this.name + " dx");
        }

        public Real norm() {
            return Values.NaN;
        }

        public boolean equals(Object o) {
            return o instanceof SymbolicFunction && Utility.equals(this.name, ((SymbolicFunction)o).name);
        }

        public int hashCode() {
            return Utility.hashCode(this.name);
        }

        public String toString() {
            return this.name + "";
        }
    }

    static final class ConstantFunction
    extends AbstractFunction
    implements VoidFunction,
    Variable {
        private Object a;

        public ConstantFunction(Object a) {
            this.a = a;
        }

        public boolean isVariable() {
            return this.a instanceof Variable && ((Variable)this.a).isVariable();
        }

        public Object apply() {
            return this.a;
        }

        public Object apply(Object x) {
            return this.apply();
        }

        public Function derive() {
            Real b = ((Normed)this.a).norm();
            return b.isInfinite() || b.isNaN() ? Functions.constant(Values.NaN) : zero;
        }

        public Function integrate() {
            return Functions.linear((Arithmetic)this.a);
        }

        public Real norm() {
            return ((Normed)this.a).norm();
        }

        public boolean equals(Object o) {
            return o instanceof ConstantFunction && Utility.equals(this.a, ((ConstantFunction)o).a);
        }

        public int hashCode() {
            return Utility.hashCode(this.a);
        }

        public String toString() {
            return this.a + "";
        }
    }
}

