/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.awt.Dimension;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Set;
import orbital.logic.functor.Function;
import orbital.math.Arithmetic;
import orbital.math.Complex;
import orbital.math.Euclidean;
import orbital.math.Fraction;
import orbital.math.Integer;
import orbital.math.Matrix;
import orbital.math.Polynomial;
import orbital.math.Quotient;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Symbol;
import orbital.math.Tensor;
import orbital.math.UnivariatePolynomial;
import orbital.math.Vector;

public interface ValueFactory {
    public Integer ZERO();

    public Integer ONE();

    public Integer MINUS_ONE();

    public Real POSITIVE_INFINITY();

    public Real NEGATIVE_INFINITY();

    public Real PI();

    public Real E();

    public Real NaN();

    public Complex I();

    public Complex i();

    public Complex INFINITY();

    public Integer valueOf(int var1);

    public Integer valueOf(java.lang.Integer var1);

    public Integer valueOf(long var1);

    public Integer valueOf(Long var1);

    public Integer valueOf(byte var1);

    public Integer valueOf(Byte var1);

    public Integer valueOf(short var1);

    public Integer valueOf(Short var1);

    public Integer valueOf(BigInteger var1);

    public Real valueOf(double var1);

    public Real valueOf(Double var1);

    public Real valueOf(float var1);

    public Real valueOf(Float var1);

    public Real valueOf(BigDecimal var1);

    public Scalar valueOf(Number var1);

    public Rational rational(Integer var1, Integer var2);

    public Rational rational(int var1, int var2);

    public Rational rational(Integer var1);

    public Rational rational(int var1);

    public Complex complex(Real var1, Real var2);

    public Complex complex(double var1, double var3);

    public Complex complex(float var1, float var2);

    public Complex complex(int var1, int var2);

    public Complex complex(long var1, long var3);

    public Complex complex(Real var1);

    public Complex complex(double var1);

    public Complex cartesian(Real var1, Real var2);

    public Complex cartesian(double var1, double var3);

    public Complex polar(Real var1, Real var2);

    public Complex polar(double var1, double var3);

    public Vector valueOf(Arithmetic[] var1);

    public Vector valueOf(double[] var1);

    public Vector valueOf(int[] var1);

    public Vector newInstance(int var1);

    public Vector ZERO(int var1);

    public Vector BASE(int var1, int var2);

    public Vector CONST(int var1, Arithmetic var2);

    public Vector constant(Vector var1);

    public Matrix valueOf(Arithmetic[][] var1);

    public Matrix valueOf(double[][] var1);

    public Matrix valueOf(int[][] var1);

    public Matrix newInstance(Dimension var1);

    public Matrix newInstance(int var1, int var2);

    public Matrix ZERO(Dimension var1);

    public Matrix ZERO(int var1, int var2);

    public Matrix IDENTITY(Dimension var1);

    public Matrix IDENTITY(int var1, int var2);

    public Matrix DIAGONAL(Vector var1);

    public Matrix constant(Matrix var1);

    public Vector tensor(Arithmetic[] var1);

    public Matrix tensor(Arithmetic[][] var1);

    public Tensor tensor(Arithmetic[][][] var1);

    public Tensor tensor(Object var1);

    public Tensor newInstance(int[] var1);

    public Tensor ZERO(int[] var1);

    public Tensor constant(Tensor var1);

    public Polynomial polynomial(Object var1);

    public Polynomial asPolynomial(Tensor var1);

    public Tensor asTensor(Polynomial var1);

    public Polynomial constant(Polynomial var1);

    public Polynomial MONOMIAL(Arithmetic var1, Arithmetic var2);

    public Polynomial MONOMIAL(Arithmetic var1, int[] var2);

    public Polynomial MONOMIAL(Arithmetic var1);

    public Polynomial MONOMIAL(int[] var1);

    public UnivariatePolynomial polynomial(Arithmetic[] var1);

    public UnivariatePolynomial polynomial(double[] var1);

    public UnivariatePolynomial polynomial(int[] var1);

    public UnivariatePolynomial asPolynomial(Vector var1);

    public Vector asVector(UnivariatePolynomial var1);

    public UnivariatePolynomial constant(UnivariatePolynomial var1);

    public Quotient quotient(Arithmetic var1, Function var2);

    public Quotient quotient(Euclidean var1, Euclidean var2);

    public Quotient quotient(Polynomial var1, Set var2, Comparator var3);

    public Quotient quotient(Euclidean var1, UnivariatePolynomial var2);

    public Quotient quotient(Euclidean var1, Function var2);

    public Quotient quotient(Arithmetic var1, Polynomial var2);

    public Quotient quotient(int var1, int var2);

    public Fraction fraction(Arithmetic var1, Arithmetic var2);

    public Symbol symbol(String var1);

    public Arithmetic valueOf(String var1) throws NumberFormatException;

    public Vector asVector(Matrix var1);

    public Vector asVector(Tensor var1);

    public Scalar narrow(Scalar var1);

    public Function getCoercer();

    public void setCoercer(Function var1) throws SecurityException;

    public Function getNormalizer();

    public void setNormalizer(Function var1) throws SecurityException;
}

