/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.awt.Dimension;
import java.util.ListIterator;
import orbital.math.Arithmetic;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Tensor;
import orbital.math.Vector;

public interface Matrix
extends Tensor {
    public Dimension dimension();

    public Arithmetic get(int var1, int var2);

    public void set(int var1, int var2, Arithmetic var3) throws UnsupportedOperationException;

    public ListIterator getColumns();

    public ListIterator getRows();

    public ListIterator iterator();

    public Vector getColumn(int var1);

    public void setColumn(int var1, Vector var2) throws UnsupportedOperationException;

    public Vector getRow(int var1);

    public void setRow(int var1, Vector var2) throws UnsupportedOperationException;

    public Matrix subMatrix(int var1, int var2, int var3, int var4);

    public Vector getDiagonal();

    public boolean isSquare();

    public boolean isSymmetric() throws ArithmeticException;

    public boolean isInvertible() throws ArithmeticException;

    public boolean isRegular() throws ArithmeticException;

    public int isDefinite() throws ArithmeticException;

    public int linearRank();

    public Real norm(double var1);

    public Real norm();

    public Arithmetic trace() throws ArithmeticException;

    public Arithmetic det() throws ArithmeticException;

    public Matrix add(Matrix var1);

    public Matrix subtract(Matrix var1);

    public Matrix multiply(Matrix var1);

    public Matrix scale(Scalar var1);

    public Matrix multiply(Scalar var1);

    public Vector multiply(Vector var1);

    public Matrix transpose();

    public Matrix conjugate();

    public Matrix pseudoInverse();

    public Matrix insertColumns(int var1, Matrix var2);

    public Matrix insertRows(int var1, Matrix var2);

    public Matrix insertColumns(Matrix var1);

    public Matrix insertRows(Matrix var1);

    public Matrix removeColumn(int var1);

    public Matrix removeRow(int var1);

    public Arithmetic[][] toArray();
}

