/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.lang.reflect.Array;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.math.AlgebraicAlgorithms;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Euclidean;
import orbital.math.GetPropertyAction;
import orbital.math.Matrix;
import orbital.math.Metric;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Function;
import orbital.util.SuspiciousError;
import orbital.util.Utility;

public final class MathUtilities {
    private static final Logger logger;
    private static int DefaultPrecisionDigits;
    private static double DefaultTolerance;
    private static final BigInteger ZERO;
    private static final BigInteger ONE;
    private static final BigInteger TWO;
    private static final BigInteger THREE;
    private static final BigInteger FOUR;
    private static final BigInteger FIVE;
    private static char[] romans;
    static final /* synthetic */ boolean $assertionsDisabled;

    private MathUtilities() {
    }

    public static void setDefaultPrecisionDigits(int defaultPrecisionDigits) {
        DefaultPrecisionDigits = defaultPrecisionDigits;
    }

    public static int getDefaultPrecisionDigits() {
        return DefaultPrecisionDigits;
    }

    public static void setDefaultTolerance(double defaultTolerance) {
        DefaultTolerance = defaultTolerance;
    }

    public static double getDefaultTolerance() {
        return DefaultTolerance;
    }

    public static final boolean isin(int value, int lower, int higher) {
        return lower <= value && value <= higher;
    }

    public static final boolean isin(double value, double lower, double higher) {
        return lower <= value && value <= higher;
    }

    public static final boolean isin(Real value, Real lower, Real higher) {
        return lower.compareTo(value) <= 0 && value.compareTo(higher) <= 0;
    }

    public static final boolean even(int value) {
        return (value & 1) == 0;
    }

    public static final boolean odd(int value) {
        return (value & 1) != 0;
    }

    public static final int sign(double value) {
        return value > 0.0 ? 1 : (value < 0.0 ? -1 : (value == 0.0 ? 0 : MathUtilities.undefined(value + " does not have a sign")));
    }

    public static final int sign(int value) {
        return value > 0 ? 1 : (value < 0 ? -1 : (value == 0 ? 0 : MathUtilities.undefined(value + " does not have a sign")));
    }

    private static final int undefined(String msg) {
        throw new ArithmeticException(msg);
    }

    public static boolean isProbability(double value) {
        return 0.0 <= value && value <= 1.0;
    }

    public static boolean isInteger(double value) {
        return MathUtilities.fract(value) == 0.0;
    }

    public static Euclidean gcd(Euclidean a, Euclidean b) {
        return AlgebraicAlgorithms.gcd(a, b);
    }

    public static Euclidean lcm(Euclidean a, Euclidean b) {
        return AlgebraicAlgorithms.lcm(a, b);
    }

    public static Euclidean[] gcd(Euclidean[] elements) {
        return AlgebraicAlgorithms.gcd(elements);
    }

    public static int gcd(int a, int b) {
        return AlgebraicAlgorithms.gcd(a, b);
    }

    public static int lcm(int a, int b) {
        return AlgebraicAlgorithms.lcm(a, b);
    }

    public static BigInteger generatePrime(int strength, int certainty, Random randSource, boolean strongPrime) {
        BigInteger p = new BigInteger(strength, certainty, randSource);
        if (strongPrime) {
            while (!p.subtract(BigInteger.valueOf(1L)).shiftRight(1).isProbablePrime(certainty)) {
                p = new BigInteger(strength, certainty, randSource);
            }
            if (!$assertionsDisabled && !MathUtilities.isPrime(p)) {
                throw new AssertionError((Object)"strong condition: prime");
            }
        }
        return p;
    }

    public static BigInteger generatePrime(int strength, Random randSource) {
        BigInteger p;
        while (!MathUtilities.isPrime(p = MathUtilities.generatePrime(strength, 100, randSource, false))) {
        }
        return p;
    }

    public static boolean isPrime(BigInteger val) {
        BigInteger p = val.abs();
        if (p.equals(ZERO)) {
            return true;
        }
        if (p.equals(ONE)) {
            return false;
        }
        if (p.equals(TWO) || p.equals(FIVE)) {
            return true;
        }
        if (!p.testBit(0)) {
            return false;
        }
        if (p.remainder(FIVE).equals(ZERO)) {
            return false;
        }
        int s = 0;
        BigInteger i = THREE;
        while (i.bitLength() <= (p.bitLength() + 1) / 2) {
            if (p.remainder(i).equals(ZERO)) {
                return false;
            }
            i = i.add(s == 0 ? FOUR : TWO);
            if (++s < 4) continue;
            s = 0;
        }
        return true;
    }

    public static long factorial(int n) {
        long r = 1L;
        while (n > 0) {
            r *= (long)n--;
        }
        return r;
    }

    public static int nCr(int n, int r) {
        return (int)(MathUtilities.factorial(n) / (MathUtilities.factorial(r) * MathUtilities.factorial(n - r)));
    }

    public static int nPr(int n, int r) {
        return (int)(MathUtilities.factorial(n) / MathUtilities.factorial(n - r));
    }

    public static int multinomial(int[] n) {
        int sum = 0;
        long prod = 1L;
        for (int i = 0; i < n.length; ++i) {
            sum += n[i];
            prod *= MathUtilities.factorial(n[i]);
        }
        return (int)(MathUtilities.factorial(sum) / prod);
    }

    public static int round(double a, int rounding_style) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static double fract(double a) {
        return a - Math.floor(a);
    }

    public static int gaussian(double a) {
        return (int)Math.floor(a);
    }

    public static double ceily(double a, double precision) {
        return Math.ceil(a / precision) * precision;
    }

    public static double ceily(double a) {
        return MathUtilities.ceily(a, MathUtilities.precisionFor(a));
    }

    public static double floory(double a, double precision) {
        return Math.floor(a / precision) * precision;
    }

    public static double floory(double a) {
        return MathUtilities.floory(a, MathUtilities.precisionFor(a));
    }

    public static double roundy(double a, double precision) {
        return (double)Math.round(a / precision) * precision;
    }

    public static double roundy(double a) {
        return MathUtilities.roundy(a, MathUtilities.precisionFor(a));
    }

    public static double precisionFor(double a, double tolerance) {
        return tolerance * Math.pow(10.0, Math.ceil(Math.log(a) / Math.log(10.0)));
    }

    public static double precisionFor(double a) {
        return MathUtilities.precisionFor(a, DefaultTolerance);
    }

    public static boolean equals(double a, double b, double tolerance) {
        return Math.abs(a - b) < tolerance;
    }

    public static boolean equals(Arithmetic a, Arithmetic b, double tolerance) {
        return Metric.INDUCED.distance(a, b).doubleValue() < tolerance;
    }

    static boolean equalsCa(double a, double b) {
        return MathUtilities.equals(a, b, DefaultTolerance);
    }

    static boolean equalsCa(Arithmetic a, Arithmetic b) {
        return MathUtilities.equals(a, b, DefaultTolerance);
    }

    public static final orbital.logic.functor.Function getEqualizer() {
        return Values.getDefault().getCoercer();
    }

    public static final void setEqualizer(orbital.logic.functor.Function equalizer) throws SecurityException {
        Values.getDefault().setCoercer(equalizer);
    }

    public static Arithmetic integrate(Function f, Arithmetic a, Arithmetic b) {
        Function F = f.integrate();
        return ((Arithmetic)F.apply(b)).subtract((Arithmetic)F.apply(a));
    }

    public static String format(double v, int precisionDigits) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = precisionDigits; i < 0; ++i) {
            sb.append('0');
        }
        sb.append('.');
        for (i = 0; i < precisionDigits; ++i) {
            sb.append('#');
        }
        DecimalFormat form = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.UK));
        StringBuffer s = new StringBuffer(form.format(v));
        while (s.charAt(s.length() - 1) == '0') {
            s.deleteCharAt(s.length() - 1);
        }
        if (s.charAt(s.length() - 1) == '.') {
            s.deleteCharAt(s.length() - 1);
        }
        if (s.length() == 0 || "-".equals(s.toString())) {
            return "0";
        }
        return s.toString();
    }

    private static String format(Number v, int precisionDigits) {
        if (v == null) {
            return "null";
        }
        return MathUtilities.format(v.doubleValue(), precisionDigits);
    }

    public static String format(double v) {
        return MathUtilities.format(v, DefaultPrecisionDigits);
    }

    public static String format(byte[] v) {
        if (v.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(3);
        for (int i = 0; i < v.length; ++i) {
            sb.append((i > 0 ? ":" : "") + nf.format(v[i] & 0xFF));
        }
        return sb.toString();
    }

    public static String format(Object o) {
        if (o == null) {
            return "" + null;
        }
        if (o instanceof Arithmetic) {
            return ArithmeticFormat.getDefaultInstance().format(o);
        }
        if (o instanceof Number) {
            if (o instanceof Integer || o instanceof Byte || o instanceof Short || o instanceof Long) {
                return ((Number)o).longValue() + "";
            }
            return MathUtilities.format(((Number)o).doubleValue());
        }
        if (o.getClass().isArray()) {
            if (!o.getClass().getComponentType().isArray()) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < Array.getLength(o); ++i) {
                    sb.append((i == 0 ? "" : ", ") + Array.get(o, i));
                }
                return "(" + sb.toString() + ")";
            }
            if (Array.getLength(o) != 0) {
                try {
                    return Values.getDefaultInstance().tensor(o).toString();
                }
                catch (IllegalArgumentException nonArithmetic) {
                    if (Utility.rank(o) != 1) {
                        return o.toString();
                    }
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < Array.getLength(o); ++i) {
                        sb.append((i == 0 ? "" : ", ") + Array.get(o, i));
                    }
                    return "(" + sb.toString() + ")";
                }
            }
            return "{}";
        }
        return "" + o;
    }

    public static String toRoman(short arabic) {
        if (arabic <= 0 || arabic >= 4000) {
            throw new IllegalArgumentException("number out of bounds");
        }
        StringBuffer sp = new StringBuffer();
        int r = romans.length - 1;
        for (int dec = 10000; dec > 1; dec = (int)((short)(dec / 10))) {
            logger.log(Level.FINEST, "" + dec, "" + MathUtilities.fract((double)arabic / (double)dec) + "->" + 10.0 * MathUtilities.fract(MathUtilities.roundy((double)arabic / (double)dec, 0.01)));
            int ch = (int)(10.0 * MathUtilities.fract(MathUtilities.roundy((double)arabic / (double)dec, 0.01)));
            switch (ch) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    int j;
                    for (j = 0; j < ch; ++j) {
                        sp.append(romans[r]);
                    }
                    break;
                }
                case 4: {
                    sp.append(romans[r]);
                }
                case 5: {
                    sp.append(romans[r + 1]);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    int j;
                    sp.append(romans[r + 1]);
                    for (j = 0; j < ch - 5; ++j) {
                        sp.append(romans[r]);
                    }
                    break;
                }
                case 9: {
                    sp.append(romans[r]);
                    sp.append(romans[r + 2]);
                    break;
                }
                default: {
                    throw new SuspiciousError("chiffre (" + ch + ") is neither 0 nor 1-9");
                }
            }
            r -= 2;
        }
        return sp.toString();
    }

    static final double[] toDoubleArray(Vector v) {
        double[] a = new double[v.dimension()];
        for (int i = 0; i < v.dimension(); ++i) {
            a[i] = ((Real)v.get(i)).doubleValue();
        }
        return a;
    }

    static final double[][] toDoubleArray(Matrix m) {
        double[][] a = new double[m.dimension().height][m.dimension().width];
        for (int i = 0; i < m.dimension().height; ++i) {
            for (int j = 0; j < m.dimension().width; ++j) {
                a[i][j] = ((Real)m.get(i, j)).doubleValue();
            }
        }
        return a;
    }

    static {
        $assertionsDisabled = !MathUtilities.class.desiredAssertionStatus();
        logger = Logger.getLogger(MathUtilities.class.getName());
        DefaultPrecisionDigits = 8;
        DefaultTolerance = 1.0E-11;
        String property = MathUtilities.class.getName() + ".defaultPrecisionDigits";
        try {
            String desc = GetPropertyAction.getProperty(property, DefaultPrecisionDigits + "");
            try {
                DefaultPrecisionDigits = Integer.parseInt(desc);
            }
            catch (NumberFormatException nonumber) {
                logger.log(Level.SEVERE, "invalid property setting {0}={1}", new Object[]{property, desc});
            }
            property = MathUtilities.class.getName() + ".defaultTolerance";
            desc = GetPropertyAction.getProperty(property, DefaultTolerance + "");
            try {
                DefaultTolerance = Double.parseDouble(desc);
            }
            catch (NumberFormatException nonumber) {
                logger.log(Level.SEVERE, "invalid property setting {0}={1}", new Object[]{property, desc});
            }
        }
        catch (SecurityException nevertheless) {
        }
        catch (Exception nevertheless) {
            logger.log(Level.WARNING, "use default property setting for {0} due to {1}", new Object[]{property, nevertheless});
        }
        logger.log(Level.CONFIG, "property setting {0}={1}", new Object[]{property, new Double(DefaultTolerance)});
        ZERO = BigInteger.valueOf(0L);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        THREE = BigInteger.valueOf(3L);
        FOUR = BigInteger.valueOf(4L);
        FIVE = BigInteger.valueOf(5L);
        romans = new char[]{'I', 'V', 'X', 'L', 'C', 'D', 'M'};
    }
}

