/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.io.Serializable;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Function;
import orbital.logic.functor.Predicate;
import orbital.logic.functor.Predicates;
import orbital.math.Arithmetic;
import orbital.math.MathUtilities;
import orbital.math.Matrix;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractMatrix;
import orbital.util.Setops;

public final class LUDecomposition
implements Serializable {
    private static final long serialVersionUID = 4112378842817846198L;
    private Matrix A;
    private Matrix P;
    private boolean sign;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected LUDecomposition(Matrix A, Matrix P, boolean sign) {
        this.A = A;
        this.P = P;
        this.sign = sign;
    }

    private LUDecomposition(Matrix M) {
        if (!M.isSquare()) {
            throw new IllegalArgumentException("only square matrices can be LU-decomposed");
        }
        AbstractMatrix A = (AbstractMatrix)M.clone();
        AbstractMatrix P = (AbstractMatrix)Values.getDefaultInstance().IDENTITY(A.dimension());
        this.sign = true;
        for (int k = 0; k < A.dimension().width - 1; ++k) {
            Arithmetic apinv;
            int i;
            int pivot = k;
            for (i = k + 1; i < A.dimension().height; ++i) {
                if (A.get(i, k).norm().compareTo(A.get(pivot, k).norm()) <= 0) continue;
                pivot = i;
            }
            if (pivot != k) {
                A.swapRows(k, pivot);
                P.swapRows(k, pivot);
                this.sign = !this.sign;
            }
            try {
                apinv = A.get(k, k).inverse();
            }
            catch (ArithmeticException x) {
                continue;
            }
            for (i = k + 1; i < A.dimension().height; ++i) {
                A.set(i, k, A.get(i, k).multiply(apinv));
            }
            for (i = k + 1; i < A.dimension().height; ++i) {
                for (int j = k + 1; j < A.dimension().width; ++j) {
                    A.set(i, j, A.get(i, j).subtract(A.get(i, k).multiply(A.get(k, j))));
                }
            }
        }
        this.A = A;
        this.P = P;
        if (!$assertionsDisabled && !P.multiply(M).equals(this.getL().multiply(this.getU()), Values.getDefaultInstance().valueOf(MathUtilities.getDefaultTolerance()))) {
            throw new AssertionError((Object)("P.A = L.U: " + P + "*" + M + "=" + P.multiply(M) + "  =  " + this.getL().multiply(this.getU()) + "=" + this.getL() + "*" + this.getU()));
        }
    }

    public static LUDecomposition decompose(Matrix M) {
        return new LUDecomposition(M);
    }

    public boolean isInvertible() throws ArithmeticException {
        for (int i = 0; i < this.A.dimension().height; ++i) {
            if (!this.A.get(i, i).norm().equals(Values.ZERO)) continue;
            return false;
        }
        return true;
    }

    public boolean isRegular() throws ArithmeticException {
        return this.isInvertible();
    }

    public int linearRank() {
        return Setops.count(this.A.getDiagonal().iterator(), (Predicate)Functionals.compose(Functionals.bindSecond(Predicates.unequal, (Object)Values.ZERO), (Function)Functions.norm));
    }

    public Arithmetic det() {
        Arithmetic detU = (Arithmetic)Functionals.foldRight((BinaryFunction)Operations.times, (Object)Values.ONE, this.A.getDiagonal().iterator());
        return this.sign ? detU : detU.minus();
    }

    public Matrix getL() {
        Matrix L = Values.getDefaultInstance().IDENTITY(this.A.dimension());
        for (int i = 0; i < this.A.dimension().height; ++i) {
            for (int j = 0; j < i; ++j) {
                L.set(i, j, this.A.get(i, j));
            }
        }
        return L;
    }

    public Matrix getU() {
        Matrix U = Values.getDefaultInstance().ZERO(this.A.dimension());
        for (int i = 0; i < this.A.dimension().height; ++i) {
            for (int j = i; j < this.A.dimension().width; ++j) {
                U.set(i, j, this.A.get(i, j));
            }
        }
        return U;
    }

    public Matrix getP() {
        return Values.getDefaultInstance().constant(this.P);
    }

    public Vector solve(Vector b) {
        Vector c = this.P.multiply(b);
        Vector z = Values.getDefaultInstance().newInstance(this.A.dimension().width);
        for (int i = 0; i < this.A.dimension().height; ++i) {
            Arithmetic t = c.get(i);
            for (int j = 0; j < i; ++j) {
                t = t.subtract(this.A.get(i, j).multiply(z.get(j)));
            }
            z.set(i, t);
        }
        Vector x = Values.getDefaultInstance().newInstance(this.A.dimension().width);
        for (int i = this.A.dimension().height - 1; i >= 0; --i) {
            Arithmetic t = c.get(i);
            for (int j = i + 1; j < this.A.dimension().width; ++j) {
                t = t.subtract(this.A.get(i, j).multiply(x.get(j)));
            }
            x.set(i, t.divide(this.A.get(i, i)));
        }
        return x;
    }

    static {
        $assertionsDisabled = !LUDecomposition.class.desiredAssertionStatus();
    }
}

