/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.algorithm.Combinatorical;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.BinaryPredicate;
import orbital.logic.functor.Function;
import orbital.logic.functor.Predicate;
import orbital.logic.functor.Predicates;
import orbital.math.Arithmetic;
import orbital.math.Euclidean;
import orbital.math.Integer;
import orbital.math.MathUtilities;
import orbital.math.Polynomial;
import orbital.math.Quotient;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Functionals;
import orbital.math.functional.Operations;
import orbital.util.Pair;
import orbital.util.ReverseComparator;
import orbital.util.Setops;
import orbital.util.Utility;

public final class AlgebraicAlgorithms {
    private static final Logger logger;
    public static final Comparator LEXICOGRAPHIC;
    public static final Comparator REVERSE_LEXICOGRAPHIC;
    public static final Comparator DEGREE_LEXICOGRAPHIC;
    public static final BinaryFunction gcd;
    public static final BinaryFunction lcm;
    private static final Predicate isZeroPolynomial;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$orbital$math$Polynomial;

    private AlgebraicAlgorithms() {
    }

    public static final Comparator INDUCED(Comparator monomialOrder) {
        return new InducedPolynomialComparator(monomialOrder);
    }

    static final Tensor flatten(Tensor t) {
        int[] sdim = null;
        ListIterator i = t.iterator();
        while (i.hasNext()) {
            Object ti = i.next();
            if (ti instanceof Tensor) {
                int[] d = ((Tensor)ti).dimensions();
                if (sdim == null) {
                    sdim = d;
                    continue;
                }
                Utility.pre(Utility.equalsAll(d, sdim), "components have uniform rank and dimensions");
                continue;
            }
            if (sdim == null) {
                sdim = new int[]{};
                continue;
            }
            Utility.pre(sdim.length == 0, "components have uniform ran and dimensions");
        }
        if (sdim.length == 0) {
            return t;
        }
        int[] tdim = t.dimensions();
        int[] dim = new int[tdim.length + sdim.length];
        System.arraycopy(tdim, 0, dim, 0, tdim.length);
        System.arraycopy(sdim, 0, dim, tdim.length, sdim.length);
        Tensor r = Values.getDefaultInstance().newInstance(dim);
        Combinatorical index = Combinatorical.getPermutations(r.dimensions());
        while (index.hasNext()) {
            int[] i2 = index.next();
            int[] ai = new int[tdim.length];
            System.arraycopy(i2, 0, ai, 0, tdim.length);
            int[] bi = new int[sdim.length];
            System.arraycopy(i2, tdim.length, bi, 0, i2.length - tdim.length);
            Tensor tai = (Tensor)t.get(ai);
            r.set(i2, tai.get(bi));
        }
        return AlgebraicAlgorithms.flatten(r);
    }

    public static Euclidean gcd(Euclidean a, Euclidean b) {
        Euclidean[] list = new Euclidean[]{a, b};
        return AlgebraicAlgorithms.gcd(list)[list.length];
    }

    public static Euclidean lcm(Euclidean a, Euclidean b) {
        return (Euclidean)a.multiply(b).divide(AlgebraicAlgorithms.gcd(a, b));
    }

    public static Euclidean[] gcd(Euclidean[] elements) {
        switch (elements.length) {
            case 0: {
                throw new IllegalArgumentException("positive array-size expected. gcd not defined for zero elements");
            }
            case 1: {
                return new Euclidean[]{(Euclidean)elements[1].one(), elements[0]};
            }
            case 2: {
                break;
            }
            default: {
                Euclidean d = (Euclidean)Functionals.foldLeft(gcd, (Object)elements[0], elements);
                throw new UnsupportedOperationException("gcd of more than two elements not yet implemented");
            }
        }
        Euclidean a = elements[0];
        Euclidean b = elements[1];
        Euclidean ZERO = (Euclidean)a.zero();
        Euclidean ONE = (Euclidean)a.one();
        if (a.norm().equals(Values.ZERO) && b.norm().equals(Values.ZERO)) {
            throw new ArithmeticException("gcd(0, 0) is undefined");
        }
        if (b.norm().equals(Values.ZERO)) {
            return new Euclidean[]{ONE, a};
        }
        Euclidean a0 = a;
        Euclidean a1 = b;
        Euclidean r0 = ONE;
        Euclidean r1 = ZERO;
        Euclidean s0 = ZERO;
        Euclidean s1 = ONE;
        while (!a1.norm().equals(Values.ZERO)) {
            Euclidean q = a0.quotient(a1);
            Euclidean t = (Euclidean)a0.subtract(q.multiply(a1));
            if (!$assertionsDisabled && !a0.modulo(a1).equals(t)) {
                throw new AssertionError((Object)("a mod b == a - (a div b)*b, i.e. " + a0.modulo(a1) + " == " + a0 + " - " + q + "*" + a1 + " == " + a0 + " - " + q.multiply(a1) + " == " + t));
            }
            a0 = a1;
            a1 = t;
            t = (Euclidean)r0.subtract(q.multiply(r1));
            r0 = r1;
            r1 = t;
            t = (Euclidean)s0.subtract(q.multiply(s1));
            s0 = s1;
            s1 = t;
        }
        if (!$assertionsDisabled && a0.norm().equals(Values.ZERO)) {
            throw new AssertionError((Object)"gcd != 0 && @todo");
        }
        if (!$assertionsDisabled && !a0.equals(r0.multiply(a).add(s0.multiply(b)))) {
            throw new AssertionError((Object)"a0 == r0*a + s0*b");
        }
        return new Euclidean[]{r0, s0, a0};
    }

    static int gcd(int a, int b) {
        if (a == 0 && b == 0) {
            throw new ArithmeticException("gcd(0, 0) is undefined");
        }
        if (b == 0) {
            return a;
        }
        boolean flipsign = false;
        if (a < 0) {
            a *= -1;
            boolean bl = flipsign = !flipsign;
        }
        if (b < 0) {
            b *= -1;
            boolean bl = flipsign = !flipsign;
        }
        if (!($assertionsDisabled || a >= 0 && b > 0)) {
            throw new AssertionError((Object)"a>=0 && b>0 for gcd, now");
        }
        while (a != 0) {
            if (b > a) {
                int t = a;
                a = b;
                b = t;
            }
            a %= b;
        }
        if (!$assertionsDisabled && b == 0) {
            throw new AssertionError((Object)"gcd != 0 && @todo");
        }
        return flipsign ? -b : b;
    }

    static int lcm(int a, int b) {
        return a * b / AlgebraicAlgorithms.gcd(a, b);
    }

    public static final Quotient chineseRemainder(Arithmetic[] x, Arithmetic[] m) {
        if (x.length != m.length) {
            throw new IllegalArgumentException("must give the same number of congruence values and modulos");
        }
        Values vf = Values.getDefaultInstance();
        Euclidean xStar = (Euclidean)x[0];
        Euclidean M = (Euclidean)xStar.one();
        for (int i = 1; i < m.length; ++i) {
            M = (Euclidean)M.multiply(m[i - 1]);
            Arithmetic c = vf.quotient(M, (Euclidean)m[i]).inverse();
            Arithmetic s = vf.quotient((Euclidean)x[i].subtract(xStar).multiply(c), (Euclidean)m[i]).representative();
            xStar = (Euclidean)xStar.add(s.multiply(M));
        }
        M = (Euclidean)M.multiply(m[m.length - 1]);
        if (!$assertionsDisabled && !M.equals(Operations.product.apply(vf.valueOf(m)))) {
            throw new AssertionError((Object)("total modulus " + M + " = " + Operations.product.apply(vf.valueOf(m))));
        }
        return vf.quotient(xStar, M);
    }

    public static final Polynomial reduce(Polynomial f, Collection g, Comparator monomialOrder) {
        return (Polynomial)AlgebraicAlgorithms.reduce(g, monomialOrder).apply(f);
    }

    public static final Function reduce(Collection g, Comparator monomialOrder) {
        return new ReductionFunction(g, monomialOrder);
    }

    public static final Set groebnerBasis(Set g, Comparator monomialOrder) {
        Set temp;
        Set rgb = AlgebraicAlgorithms.reducedGroebnerBasis(g, monomialOrder);
        Set nrgb = null;
        if (!$assertionsDisabled && !((Object)(temp = AlgebraicAlgorithms.reducedGroebnerBasis(rgb, monomialOrder))).equals(rgb)) {
            throw new AssertionError((Object)("reduced Groebner basis " + temp + " of a reduced Groebner basis equals the former Groebner basis"));
        }
        if (!$assertionsDisabled && !((Object)(temp = AlgebraicAlgorithms.groebnerBasisImpl(rgb, monomialOrder))).equals(rgb)) {
            throw new AssertionError((Object)("(non-reduced) Groebner basis " + temp + " of a (reduced) Groebner basis " + rgb + " equals the former Groebner basis"));
        }
        if (!$assertionsDisabled && !AlgebraicAlgorithms.containsAll(nrgb = AlgebraicAlgorithms.groebnerBasisImpl(g, monomialOrder), g, monomialOrder)) {
            throw new AssertionError((Object)("the original generating system " + g + " is in the ideal spanned by its (non-reduced) Groebner basis " + nrgb));
        }
        if (!$assertionsDisabled && !AlgebraicAlgorithms.equalSpan(rgb, nrgb, monomialOrder)) {
            throw new AssertionError((Object)("reduced Groebner basis " + rgb + " and (non-reduced) Groebner basis " + nrgb + " of " + g + " have equal span"));
        }
        if (!$assertionsDisabled && !AlgebraicAlgorithms.containsAll(rgb, g, monomialOrder)) {
            throw new AssertionError((Object)("the original generating system " + g + " is in the ideal spanned by its (reduced) Groebner basis " + rgb));
        }
        return rgb;
    }

    private static final Set reducedGroebnerBasis(Collection g, Comparator monomialOrder) {
        return new HashSet(AlgebraicAlgorithms.reduceGroebnerBasis(new ArrayList(AlgebraicAlgorithms.groebnerBasisImpl(g, monomialOrder)), monomialOrder));
    }

    private static final Set groebnerBasisImpl(Collection gg, Comparator monomialOrder) {
        ArrayList<Polynomial> g = new ArrayList<Polynomial>(gg);
        Values vf = Values.getDefaultInstance();
        while (true) {
            block1: for (int i = 0; i < g.size(); ++i) {
                for (int j = i + 1; j < g.size(); ++j) {
                    Polynomial gi = (Polynomial)g.get(i);
                    Polynomial gj = (Polynomial)g.get(j);
                    Vector lgi = (Vector)AlgebraicAlgorithms.leadingMonomial(gi, monomialOrder);
                    Vector lgj = (Vector)AlgebraicAlgorithms.leadingMonomial(gj, monomialOrder);
                    Vector d = Functionals.map(Operations.max, lgi, lgj);
                    Vector nu = d.subtract(lgi);
                    Vector mu = d.subtract(lgj);
                    if (!$assertionsDisabled && !Setops.all(nu.iterator(), mu.iterator(), new BinaryPredicate(){

                        public boolean apply(Object nui, Object mui) {
                            return nui.equals(Values.ZERO) || mui.equals(Values.ZERO);
                        }
                    })) {
                        throw new AssertionError((Object)("coprime " + vf.MONOMIAL(nu) + " and " + vf.MONOMIAL(mu)));
                    }
                    Polynomial Xpowernugi = vf.MONOMIAL(gi.get(lgi).inverse(), nu).multiply(gi);
                    Polynomial Xpowermugj = vf.MONOMIAL(gj.get(lgj).inverse(), mu).multiply(gj);
                    if (!$assertionsDisabled && !AlgebraicAlgorithms.leadingMonomial(Xpowernugi, monomialOrder).equals(AlgebraicAlgorithms.leadingMonomial(Xpowermugj, monomialOrder))) {
                        throw new AssertionError((Object)("construction should generate equal leading monomials (" + AlgebraicAlgorithms.leadingMonomial(Xpowernugi, monomialOrder) + " of " + Xpowernugi + " and " + AlgebraicAlgorithms.leadingMonomial(Xpowermugj, monomialOrder) + " of " + Xpowermugj + ") which vanish by subtraction"));
                    }
                    Polynomial Sgigj = Xpowernugi.subtract(Xpowermugj);
                    if (!$assertionsDisabled && !Sgigj.get(d).norm().equals(Values.ZERO)) {
                        throw new AssertionError((Object)"construction should generate equal leading monomials which vanish by subtraction");
                    }
                    Polynomial r = AlgebraicAlgorithms.reduce(Sgigj, g, monomialOrder);
                    logger.log(Level.FINER, "S({0},{1}) = {2} * ({3})  -  {4} * ({5}) = {6} reduced to {7}", new Object[]{gi, gj, vf.MONOMIAL(gi.get(lgi).inverse(), nu), gi, vf.MONOMIAL(gj.get(lgj).inverse(), mu), gj, Sgigj, r});
                    if (!isZeroPolynomial.apply(r)) {
                        logger.log(Level.FINE, "add reduction {0} of {1} from {2} and {3}", new Object[]{r, Sgigj, gi, gj});
                        g.add(r);
                        continue block1;
                    }
                    logger.log(Level.FINE, "skip reduction {0} of {1} from {2} and {3}", new Object[]{r, Sgigj, gi, gj});
                }
            }
            break;
        }
        return new HashSet(g);
    }

    private static final List reduceGroebnerBasis(Collection g, Comparator monomialOrder) {
        ArrayList<Polynomial> basis = new ArrayList<Polynomial>(g);
        logger.log(Level.FINE, "reducing Groebner basis {0}", basis);
        while (true) {
            for (int i = 0; i < basis.size(); ++i) {
                Polynomial gi = (Polynomial)basis.get(i);
                LinkedList others = new LinkedList(basis);
                others.remove(i);
                Polynomial r = AlgebraicAlgorithms.reduce(gi, others, monomialOrder);
                if (r.equals(gi)) continue;
                basis.remove(i);
                if (isZeroPolynomial.apply(r)) {
                    logger.log(Level.FINER, "remove {0} and skip adding reduction {1}", new Object[]{gi, r});
                    continue;
                }
                basis.add(r);
                logger.log(Level.FINER, "replace {0} by reduction {1}", new Object[]{gi, r});
            }
            break;
        }
        return basis;
    }

    private static Collection occurringMonomials(final Polynomial f) {
        return Setops.select(null, (Collection)Setops.asList(f.indices()), new Predicate(){

            public boolean apply(Object i) {
                return !f.get((Arithmetic)i).norm().equals(Values.ZERO);
            }
        });
    }

    private static Arithmetic leadingMonomial(Polynomial f, Comparator monomialOrder) {
        return (Arithmetic)Collections.max(AlgebraicAlgorithms.occurringMonomials(f), monomialOrder);
    }

    private static final boolean containsAll(Set groebnerBasis, Collection f, Comparator monomialOrder) {
        Function reductor = Functionals.bindFirst(Functionals.apply, (Object)AlgebraicAlgorithms.reduce(groebnerBasis, monomialOrder));
        Predicate isZero = isZeroPolynomial;
        Predicate.Composite inIdeal = Functionals.compose(isZero, reductor);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "\t{0}\nisin\t{1}\nall\t{2}", new Object[]{Functionals.map(reductor, new LinkedList(f)), Functionals.map(Functionals.asFunction(inIdeal), new LinkedList(f)), new Boolean(Setops.all(f, (Predicate)inIdeal))});
        }
        return Setops.all(f, (Predicate)inIdeal);
    }

    private static final boolean equalSpan(Set groebnerBasis1, Set groebnerBasis2, Comparator monomialOrder) {
        return AlgebraicAlgorithms.containsAll(groebnerBasis1, groebnerBasis2, monomialOrder) && AlgebraicAlgorithms.containsAll(groebnerBasis2, groebnerBasis1, monomialOrder);
    }

    static {
        $assertionsDisabled = !AlgebraicAlgorithms.class.desiredAssertionStatus();
        logger = Logger.getLogger(AlgebraicAlgorithms.class.getName());
        LEXICOGRAPHIC = new Comparator(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public int compare(Object m1, Object m2) {
                Vector nu = (Vector)m1;
                Vector mu = (Vector)m2;
                if (nu.dimension() != mu.dimension()) {
                    throw new IllegalArgumentException("incompatible monomial exponents from polynomial rings with a different number of variables");
                }
                ListIterator k = nu.iterator();
                ListIterator j = mu.iterator();
                while (k.hasNext() || j.hasNext()) {
                    if (!($assertionsDisabled || k.hasNext() && j.hasNext())) {
                        throw new AssertionError((Object)"equal dimensions have equally structured iterators");
                    }
                    int c = ((Integer)k.next()).subtract((Integer)j.next()).intValue();
                    if (c == 0) continue;
                    return c;
                }
                return 0;
            }

            public String toString() {
                return (class$orbital$math$AlgebraicAlgorithms == null ? (class$orbital$math$AlgebraicAlgorithms = AlgebraicAlgorithms.class$("orbital.math.AlgebraicAlgorithms")) : class$orbital$math$AlgebraicAlgorithms).getName() + ".LEXICOGRAPHIC";
            }

            static {
                $assertionsDisabled = !(class$orbital$math$AlgebraicAlgorithms == null ? (class$orbital$math$AlgebraicAlgorithms = AlgebraicAlgorithms.class$("orbital.math.AlgebraicAlgorithms")) : class$orbital$math$AlgebraicAlgorithms).desiredAssertionStatus();
            }
        };
        REVERSE_LEXICOGRAPHIC = new Comparator(){

            public int compare(Object m1, Object m2) {
                Vector nu = (Vector)m1;
                Vector mu = (Vector)m2;
                if (nu.dimension() != mu.dimension()) {
                    throw new IllegalArgumentException("incompatible monomial exponents from polynomial rings with a different number of variables");
                }
                for (int k = nu.dimension() - 1; k >= 0; --k) {
                    int c = ((Integer)nu.get(k)).subtract((Integer)mu.get(k)).intValue();
                    if (c == 0) continue;
                    return c;
                }
                return 0;
            }

            public String toString() {
                return (class$orbital$math$AlgebraicAlgorithms == null ? (class$orbital$math$AlgebraicAlgorithms = AlgebraicAlgorithms.class$("orbital.math.AlgebraicAlgorithms")) : class$orbital$math$AlgebraicAlgorithms).getName() + ".REVERSE_LEXICOGRAPHIC";
            }
        };
        DEGREE_LEXICOGRAPHIC = new Comparator(){

            public int compare(Object m1, Object m2) {
                Vector nu = (Vector)m1;
                Vector mu = (Vector)m2;
                if (nu.dimension() != mu.dimension()) {
                    throw new IllegalArgumentException("incompatible monomial exponents from polynomial rings with a different number of variables");
                }
                int c = ((Integer)Operations.sum.apply(nu)).intValue() - ((Integer)Operations.sum.apply(mu)).intValue();
                if (c != 0) {
                    return c;
                }
                return LEXICOGRAPHIC.compare(m1, m2);
            }

            public String toString() {
                return (class$orbital$math$AlgebraicAlgorithms == null ? (class$orbital$math$AlgebraicAlgorithms = AlgebraicAlgorithms.class$("orbital.math.AlgebraicAlgorithms")) : class$orbital$math$AlgebraicAlgorithms).getName() + ".DEGREE_LEXICOGRAPHIC";
            }
        };
        gcd = new BinaryFunction(){

            public Object apply(Object a, Object b) {
                return AlgebraicAlgorithms.gcd((Euclidean)a, (Euclidean)b);
            }
        };
        lcm = new BinaryFunction(){

            public Object apply(Object a, Object b) {
                return AlgebraicAlgorithms.lcm((Euclidean)a, (Euclidean)b);
            }
        };
        isZeroPolynomial = new Predicate(){

            public boolean apply(Object p) {
                Polynomial r = (Polynomial)p;
                Values vf = Values.getDefaultInstance();
                return r.degreeValue() < 0 || vf.asTensor(r).norm().equals(Values.ZERO, vf.valueOf(MathUtilities.getDefaultTolerance()));
            }
        };
    }

    private static final class ReductionFunction
    implements Function,
    Serializable {
        private static final long serialVersionUID = -51945340881045435L;
        private final Collection g;
        private final Comparator monomialOrder;
        private final Function elementaryReduce;

        public ReductionFunction(Collection g, Comparator newmonomialOrder) {
            Utility.pre(Setops.all(g, Functionals.bindSecond(Utility.instanceOf, (Object)(class$orbital$math$Polynomial == null ? (class$orbital$math$Polynomial = AlgebraicAlgorithms.class$("orbital.math.Polynomial")) : class$orbital$math$Polynomial))), "collection<" + (class$orbital$math$Polynomial == null ? (class$orbital$math$Polynomial = AlgebraicAlgorithms.class$("orbital.math.Polynomial")) : class$orbital$math$Polynomial).getName() + "> expected");
            this.g = g;
            this.monomialOrder = newmonomialOrder;
            Pair[] basis = new Pair[g.size()];
            Iterator it = g.iterator();
            for (int i = 0; i < basis.length; ++i) {
                Polynomial gi = (Polynomial)it.next();
                Arithmetic leadingMonomial = AlgebraicAlgorithms.leadingMonomial(gi, this.monomialOrder);
                basis[i] = new Pair(gi, leadingMonomial);
            }
            this.elementaryReduce = new Function(this, basis){
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ Pair[] val$basis;
                private final /* synthetic */ ReductionFunction this$0;
                {
                    this.this$0 = this$0;
                    this.val$basis = val$basis;
                }

                public Object apply(Object o) {
                    Polynomial f = (Polynomial)o;
                    Values vf = Values.getDefaultInstance();
                    TreeSet<E> occurring = new TreeSet<E>(new ReverseComparator(ReductionFunction.access$200(this.this$0)));
                    occurring.addAll(AlgebraicAlgorithms.access$000(f));
                    Iterator<E> index = occurring.iterator();
                    while (index.hasNext()) {
                        Arithmetic nu = (Arithmetic)index.next();
                        Arithmetic cnu = f.get(nu);
                        if (!$assertionsDisabled && cnu.norm().equals(Values.ZERO)) {
                            throw new AssertionError((Object)"@postconditions of occurringMonomials(...)");
                        }
                        for (int j = 0; j < this.val$basis.length; ++j) {
                            Arithmetic xdiv;
                            Arithmetic cdiv;
                            Polynomial gj = (Polynomial)this.val$basis[j].A;
                            Arithmetic lgj = (Arithmetic)this.val$basis[j].B;
                            try {
                                cdiv = cnu.divide(gj.get(lgj));
                                xdiv = nu.subtract(lgj);
                                if (Setops.some(((Vector)xdiv).iterator(), Functionals.bindSecond(Predicates.less, (Object)Values.ZERO))) {
                                }
                            }
                            catch (ArithmeticException indivisible) {}
                            continue;
                            Polynomial q = vf.MONOMIAL(cdiv, xdiv);
                            Polynomial reduction = f.subtract(q.multiply(gj));
                            if (!$assertionsDisabled && !reduction.get(nu).norm().equals(Values.ZERO)) {
                                throw new AssertionError((Object)(vf.MONOMIAL((Arithmetic)Values.ONE, nu) + " does not occur in " + reduction + " anymore"));
                            }
                            if (!$assertionsDisabled && AlgebraicAlgorithms.INDUCED(ReductionFunction.access$200(this.this$0)).compare(reduction, f) >= 0) {
                                throw new AssertionError((Object)(reduction + "<" + f));
                            }
                            if (!reduction.get(nu).norm().equals(Values.ZERO)) {
                                throw new AssertionError((Object)(vf.MONOMIAL((Arithmetic)Values.ONE, nu) + " does not occur in " + reduction + " anymore"));
                            }
                            if (AlgebraicAlgorithms.INDUCED(ReductionFunction.access$200(this.this$0)).compare(reduction, f) >= 0) {
                                throw new AssertionError((Object)(reduction + "<" + f));
                            }
                            AlgebraicAlgorithms.access$300().log(Level.FINEST, "elementary reduction {0} - {1} * ({2}) == {3}", new Object[]{f, q, gj, reduction});
                            return reduction;
                        }
                    }
                    return f;
                }

                static {
                    $assertionsDisabled = !(class$orbital$math$AlgebraicAlgorithms == null ? (class$orbital$math$AlgebraicAlgorithms = AlgebraicAlgorithms.class$("orbital.math.AlgebraicAlgorithms")) : class$orbital$math$AlgebraicAlgorithms).desiredAssertionStatus();
                }
            };
        }

        public boolean equals(Object o) {
            return o instanceof ReductionFunction && Utility.equals(this.g, ((ReductionFunction)o).g) && Utility.equals(this.monomialOrder, ((ReductionFunction)o).monomialOrder);
        }

        public int hashCode() {
            return Utility.hashCode(this.g) ^ Utility.hashCode(this.monomialOrder);
        }

        public Object apply(Object f) {
            logger.log(Level.FINEST, "reducing ({0} with respect to {1} ...", new Object[]{f, this.g});
            return Functionals.fixedPoint(this.elementaryReduce, f);
        }

        static /* synthetic */ Comparator access$200(ReductionFunction x0) {
            return x0.monomialOrder;
        }
    }

    private static final class InducedPolynomialComparator
    implements Comparator {
        private final Comparator monomialOrder;

        public InducedPolynomialComparator(Comparator monomialOrder) {
            this.monomialOrder = monomialOrder;
        }

        public boolean equals(Object o) {
            return o instanceof InducedPolynomialComparator && ((Object)this.monomialOrder).equals(((InducedPolynomialComparator)o).monomialOrder);
        }

        public int hashCode() {
            return this.monomialOrder.hashCode();
        }

        public int compare(Object p1, Object p2) {
            TreeSet amon = new TreeSet(new ReverseComparator(this.monomialOrder));
            amon.addAll(AlgebraicAlgorithms.occurringMonomials((Polynomial)p1));
            TreeSet bmon = new TreeSet(new ReverseComparator(this.monomialOrder));
            bmon.addAll(AlgebraicAlgorithms.occurringMonomials((Polynomial)p2));
            try {
                Iterator i = amon.iterator();
                Iterator j = bmon.iterator();
                while (i.hasNext() || j.hasNext()) {
                    if (!i.hasNext() || !j.hasNext()) {
                        if (((Polynomial)p1).degreeValue() < 0) {
                            return -1;
                        }
                        if (((Polynomial)p2).degreeValue() < 0) {
                            return 1;
                        }
                        throw new IndexOutOfBoundsException();
                    }
                    int cmp = this.monomialOrder.compare(i.next(), j.next());
                    if (cmp == 0) continue;
                    return cmp;
                }
                return 0;
            }
            catch (IndexOutOfBoundsException differentLengthOfMonomials) {
                Function Xpower = new Function(this){
                    private final /* synthetic */ InducedPolynomialComparator this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object apply(Object i) {
                        return Values.getDefaultInstance().MONOMIAL((int[])i);
                    }

                    public String toString() {
                        return "X0^.*...Xn^.";
                    }
                };
                throw (IllegalArgumentException)new IllegalArgumentException("incomparable arguments " + p1 + " and " + p2 + "\nwith (sorted) monomials " + Functionals.map(Xpower, new LinkedList(amon)) + " and " + Functionals.map(Xpower, new LinkedList(bmon))).initCause(differentLengthOfMonomials);
            }
        }
    }
}

