/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.game.AdversarySearch;
import orbital.game.Field;
import orbital.game.Figure;
import orbital.robotic.Direction;
import orbital.robotic.Move;
import orbital.robotic.Moving;
import orbital.robotic.Position;
import orbital.util.Pair;

public class FigureImpl
extends Figure {
    private static final long serialVersionUID = 5872415441343592642L;
    private static final Logger logger = Logger.getLogger(Figure.class.getPackage().getName());
    private Field field = null;
    private transient Image image;
    private Move[] legalMoves;

    public FigureImpl(Field fld, int x, int y, Direction dir, int leag, int typ, Image img, Move[] legals) {
        super(x, y, dir, leag, typ);
        this.setImage(img);
        this.setField(fld);
        this.setLegalMoves(legals);
    }

    public FigureImpl(int x, int y, Direction dir, int leag, int typ, Image img, Move[] legals) {
        this(null, x, y, dir, leag, typ, img, legals);
    }

    public FigureImpl(int x, int y, Direction dir, int leag, int typ, Image img) {
        super(x, y, dir, leag, typ);
        this.setImage(img);
    }

    public FigureImpl(int x, int y, int leag, int typ) {
        this(x, y, new Direction(270), leag, typ, null);
    }

    public Field getField() {
        return this.field;
    }

    protected void setField(Field f) {
        this.field = f;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Move[] getLegalMoves() {
        return this.legalMoves;
    }

    public void setLegalMoves(Move[] moves) {
        this.legalMoves = moves;
    }

    public void setEmpty() {
        super.setEmpty();
        this.setImage(null);
    }

    public Dimension getPreferredSize() {
        Image image = this.getImage();
        if (image == null) {
            return null;
        }
        Dimension dim = new Dimension(image.getWidth(null), image.getHeight(null));
        return dim.width >= 0 && dim.height >= 0 ? dim : null;
    }

    public void paint(Graphics g, Rectangle box) {
        Image image = this.getImage();
        if (image != null) {
            g.drawImage(image, box.x, box.y, box.width, box.height, null);
        }
    }

    public final Iterator iterator() {
        return Arrays.asList(this.getLegalMoves()).iterator();
    }

    public final Iterator iterateValid() {
        Move[] legalMoves = this.getLegalMoves();
        ArrayList<Move> v = new ArrayList<Move>(legalMoves.length);
        for (int i = 0; i < legalMoves.length; ++i) {
            Position destination = this.movePath(legalMoves[i]);
            if (destination == null) continue;
            v.add(legalMoves[i]);
        }
        return v.iterator();
    }

    public final Iterator iterateValidPairs() {
        Move[] legalMoves = this.getLegalMoves();
        ArrayList<Pair> v = new ArrayList<Pair>(legalMoves.length);
        for (int i = 0; i < legalMoves.length; ++i) {
            Move move = legalMoves[i];
            Position destination = this.movePath(move);
            if (destination == null) continue;
            v.add(new Pair(move, destination));
        }
        return v.iterator();
    }

    public Iterator possibleMoves() {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot move empty figure " + this);
        }
        Move[] legalMoves = this.getLegalMoves();
        ArrayList<AdversarySearch.Option> v = new ArrayList<AdversarySearch.Option>(legalMoves.length);
        for (int i = 0; i < legalMoves.length; ++i) {
            Move move = legalMoves[i];
            Position destination = this.movePath(move);
            if (destination == null) continue;
            v.add(new AdversarySearch.Option(null, this, move, destination));
        }
        return v.iterator();
    }

    public Position moveFigure(Move move) {
        if (this.isEmpty()) {
            throw new IllegalStateException("cannot move empty figure " + this);
        }
        if (move == null) {
            throw new NullPointerException("illegal move: " + move);
        }
        Move[] legalMoves = this.getLegalMoves();
        for (int i = 0; i < legalMoves.length; ++i) {
            if (!move.equals(legalMoves[i])) continue;
            Position destination = this.movePath(move);
            return destination != null && this.moving(move, destination) ? destination : null;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "illegal move {0} for {1} not in the {3} options {2}", new Object[]{move, this, Arrays.asList(legalMoves), new Integer(legalMoves.length)});
        }
        throw new IllegalArgumentException("illegal move: " + move + " for " + this);
    }

    protected boolean moving(Move move, Position destination) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Position movePath(Move move) {
        if (move == null) {
            throw new NullPointerException("null is not a move");
        }
        Field field = this.getField();
        boolean was_jumping = false;
        Moving hyp = new Moving(this);
        String movement = move.getMovementString();
        if (!field.inRange(hyp)) {
            throw new IllegalStateException("illegal position " + this + " not on field range, so we cannot move at all");
        }
        int i = 0;
        while (true) {
            block15: {
                if (i >= movement.length()) {
                    return hyp;
                }
                switch (movement.charAt(i)) {
                    case '#': {
                        throw new UnsupportedOperationException("teleport not yet supported");
                    }
                    case '_': {
                        was_jumping = true;
                        break block15;
                    }
                    case '/': {
                        int n = ++i;
                        ++i;
                        hyp.move(movement.charAt(n));
                        break;
                    }
                    case '*': {
                        if (field.isEmpty(hyp) && !was_jumping) {
                            return null;
                        }
                        was_jumping = false;
                        break block15;
                    }
                }
                hyp.move(movement.charAt(i));
                if (!field.inRange(hyp)) {
                    return null;
                }
                if (was_jumping) {
                    was_jumping = false;
                } else if (!move.isBeating(i + 1) && !field.isEmpty(hyp)) {
                    return null;
                }
            }
            ++i;
        }
    }
}

