/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import orbital.game.FieldChangeEvent;
import orbital.game.FieldChangeListener;

class FieldChangeSupport
implements FieldChangeListener,
Serializable {
    private static final long serialVersionUID = 5762015723242972218L;
    private transient Vector listeners = null;

    public synchronized void addFieldChangeListener(FieldChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(listener);
    }

    public synchronized void removeFieldChangeListener(FieldChangeListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentChanged(FieldChangeEvent evt) {
        Vector targets = null;
        FieldChangeSupport fieldChangeSupport = this;
        synchronized (fieldChangeSupport) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                FieldChangeListener target = (FieldChangeListener)targets.elementAt(i);
                target.componentChanged(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movePerformed(FieldChangeEvent evt) {
        Vector targets = null;
        FieldChangeSupport fieldChangeSupport = this;
        synchronized (fieldChangeSupport) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                FieldChangeListener target = (FieldChangeListener)targets.elementAt(i);
                target.movePerformed(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(FieldChangeEvent evt) {
        Vector targets = null;
        FieldChangeSupport fieldChangeSupport = this;
        synchronized (fieldChangeSupport) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                FieldChangeListener target = (FieldChangeListener)targets.elementAt(i);
                target.stateChanged(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Vector v = null;
        FieldChangeSupport fieldChangeSupport = this;
        synchronized (fieldChangeSupport) {
            if (this.listeners != null) {
                v = (Vector)this.listeners.clone();
            }
        }
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                FieldChangeListener l = (FieldChangeListener)v.elementAt(i);
                if (!(l instanceof Serializable)) continue;
                s.writeObject(l);
            }
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        s.defaultReadObject();
        while (null != (listenerOrNull = s.readObject())) {
            this.addFieldChangeListener((FieldChangeListener)listenerOrNull);
        }
    }
}

