/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.game.AdversarySearch;
import orbital.game.FieldChangeEvent;
import orbital.game.FieldChangeListener;
import orbital.game.FieldChangeSupport;
import orbital.game.Figure;
import orbital.game.FigureImpl;
import orbital.robotic.Move;
import orbital.robotic.Position;
import orbital.util.Setops;
import orbital.util.Utility;

public class Field
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5715424141700986103L;
    private static final Logger logger;
    private Figure[][] field;
    private int turn;
    private FieldChangeSupport changeSupport = new FieldChangeSupport();
    static final /* synthetic */ boolean $assertionsDisabled;

    public Field(int width, int height) {
        this.field = new Figure[height][width];
    }

    protected Field(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    protected Field() {
        this.field = null;
    }

    public Object clone() throws CloneNotSupportedException {
        Field f = (Field)super.clone();
        f.changeSupport = new FieldChangeSupport();
        f.field = new Figure[this.field.length][this.field[0].length];
        for (int y = 0; y < this.field.length; ++y) {
            for (int x = 0; x < this.field[0].length; ++x) {
                Figure cf;
                Figure figure = this.field[y][x];
                if (!$assertionsDisabled && !this.validateFigureKnowledge(figure, new Position(x, y))) {
                    throw new AssertionError();
                }
                f.field[y][x] = cf = figure == null ? null : (Figure)figure.clone();
                if (cf != null) {
                    cf.setField(f);
                }
                if (!$assertionsDisabled && !f.validateFigureKnowledge(cf, new Position(x, y))) {
                    throw new AssertionError();
                }
            }
        }
        return f;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Field) {
            Field B = (Field)obj;
            if (!this.getDimension().equals(B.getDimension())) {
                return false;
            }
            Iterator t = this.iterator();
            Iterator e = B.iterator();
            while (t.hasNext() && e.hasNext()) {
                Figure f2;
                Figure f1 = (Figure)t.next();
                if (Utility.equals(f1, f2 = (Figure)e.next())) continue;
                return false;
            }
            if (!$assertionsDisabled && (t.hasNext() || e.hasNext())) {
                throw new AssertionError((Object)"number of elements must be equal if dimension is equal");
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        throw new InternalError("not yet implemented");
    }

    public Dimension getDimension() {
        return new Dimension(this.field[0].length, this.field.length);
    }

    public Figure getFigure(Position p) {
        if (!this.inRange(p)) {
            throw new IndexOutOfBoundsException("position " + p + " exceeds bounds " + this.getDimension());
        }
        Figure f = this.field[p.y][p.x];
        if (!$assertionsDisabled && !this.validateFigureKnowledge(f, p)) {
            throw new AssertionError();
        }
        return f;
    }

    private final boolean validateFigureKnowledge(Figure f, Position p) {
        if (!$assertionsDisabled && f instanceof FigureImpl && ((FigureImpl)f).getField() != this) {
            throw new AssertionError((Object)("figures know on which field they are: " + f + " on field " + this + " thinks it is on field " + ((FigureImpl)f).getField()));
        }
        if (!($assertionsDisabled || f == null || f.x == p.x && f.y == p.y)) {
            throw new AssertionError((Object)("figures know their position: " + f + " knows it is at " + p));
        }
        return true;
    }

    public void setFigure(Position p, Figure f) {
        Figure old = this.getFigure(p);
        this.internalSetFigure(p, f);
        this.changeSupport.componentChanged(new FieldChangeEvent(this, 1, p));
    }

    private void internalSetFigure(Position p, Figure f) {
        this.field[p.y][p.x] = f;
        if (f != null) {
            FigureImpl f2;
            f.move(p);
            if (f instanceof FigureImpl && (f2 = (FigureImpl)f).getField() != null && f2.getField() != this) {
                logger.log(Level.WARNING, "unsafe composite figure {0} was in {1} and is transferred to {2} in an unsafe way", new Object[]{f2, f2.getField(), this});
            }
            f.setField(this);
        }
        if (!$assertionsDisabled && !this.validateFigureKnowledge(f, p)) {
            throw new AssertionError();
        }
    }

    public int getTurn() {
        return this.turn;
    }

    protected void setTurn(int leagueThatMoves) {
        this.turn = leagueThatMoves;
    }

    public final boolean isEmpty(Position p) {
        Figure f = this.getFigure(p);
        return f == null || f.isEmpty();
    }

    public Dimension getPreferredSize() {
        int maxwidth = 0;
        int maxheight = 0;
        Iterator i = this.iterateNonEmpty();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            Dimension d = f.getPreferredSize();
            if (d == null) continue;
            if (d.width > maxwidth) {
                maxwidth = d.width;
            }
            if (d.height <= maxheight) continue;
            maxheight = d.height;
        }
        Dimension fields = this.getDimension();
        return new Dimension(fields.width * maxwidth, fields.height * maxheight);
    }

    public void addFieldChangeListener(FieldChangeListener listener) {
        this.changeSupport.addFieldChangeListener(listener);
    }

    public void removeFieldChangeListener(FieldChangeListener listener) {
        this.changeSupport.removeFieldChangeListener(listener);
    }

    protected final FieldChangeListener getFieldChangeMulticaster() {
        return this.changeSupport;
    }

    public final boolean inRange(Point p) {
        if (p == null) {
            throw new NullPointerException("illegal position: null");
        }
        if (p.x < 0 || p.x >= this.field[0].length) {
            return false;
        }
        return p.y >= 0 && p.y < this.field.length;
    }

    public final Iterator iterator() {
        Dimension dim = this.getDimension();
        ArrayList<Figure> v = new ArrayList<Figure>(dim.height * dim.width);
        for (int y = 0; y < dim.height; ++y) {
            for (int x = 0; x < dim.width; ++x) {
                v.add(this.getFigure(new Position(x, y)));
            }
        }
        return Setops.unmodifiableIterator(v.iterator());
    }

    public final Iterator iterateNonEmpty() {
        Dimension dim = this.getDimension();
        LinkedList<Figure> v = new LinkedList<Figure>();
        for (int y = 0; y < dim.height; ++y) {
            for (int x = 0; x < dim.width; ++x) {
                Position p = new Position(x, y);
                if (this.isEmpty(p)) continue;
                v.add(this.getFigure(p));
            }
        }
        return Setops.unmodifiableIterator(v.iterator());
    }

    public Iterator expand() {
        try {
            LinkedList<AdversarySearch.Option> l = new LinkedList<AdversarySearch.Option>();
            Iterator i = this.iterateNonEmpty();
            while (i.hasNext()) {
                Figure figure = (Figure)i.next();
                Figure org_figure = null;
                if (!$assertionsDisabled && (org_figure = (Figure)figure.clone()) == figure) {
                    throw new AssertionError((Object)"prepare");
                }
                Iterator j = figure.possibleMoves();
                while (j.hasNext()) {
                    AdversarySearch.Option o = (AdversarySearch.Option)j.next();
                    if (o.getState() != null) {
                        l.add(o);
                    } else {
                        Move move = o.getMove();
                        Position destination = o.getDestination();
                        Position org_destination = null;
                        if (!$assertionsDisabled && (org_destination = (Position)destination.clone()) == figure) {
                            throw new AssertionError((Object)"prepare");
                        }
                        Field field = (Field)this.clone();
                        if (field.move(figure, move)) {
                            l.add(new AdversarySearch.Option(field, destination, figure, move));
                        }
                        if (!$assertionsDisabled && !destination.equals(org_destination)) {
                            throw new AssertionError((Object)"moving on a cloned field does not change our control parameter destination");
                        }
                    }
                    if (!$assertionsDisabled && !figure.equals(org_figure)) {
                        throw new AssertionError((Object)"moving on a cloned field does not change our control parameter figure");
                    }
                }
            }
            return Setops.unmodifiableIterator(l.iterator());
        }
        catch (CloneNotSupportedException ass) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"invariant: sub classes must support nullary constructor for cloning."))).initCause(ass));
        }
    }

    public boolean move(Position source, Move move) {
        Position oldSource = null;
        if (!$assertionsDisabled && (oldSource = (Position)source.clone()) == null) {
            throw new AssertionError();
        }
        Figure sourceFigure = this.getFigure(source);
        if (sourceFigure == source) {
            throw new IllegalArgumentException("do not specify positions with those figures on the field that will get moved. Otherwise, their position information will get lost. But source==getFigure(source)");
        }
        Position destination = sourceFigure.moveFigure(move);
        if (!$assertionsDisabled && !oldSource.equals(source)) {
            throw new AssertionError((Object)"moving does not change the source position");
        }
        if (!$assertionsDisabled && destination == source) {
            throw new AssertionError((Object)"do not specify positions with those figures on the field that will get moved. Otherwise, their position information will get lost. But after move, source==destination");
        }
        if (destination == null) {
            return false;
        }
        this.changeSupport.movePerformed(new FieldChangeEvent(this, 2, new AdversarySearch.Option(null, destination, sourceFigure, move)));
        if (!$assertionsDisabled && !oldSource.equals(source)) {
            throw new AssertionError((Object)"moving does not change the source position");
        }
        this.swap(source, destination);
        if (!$assertionsDisabled && !oldSource.equals(source)) {
            throw new AssertionError((Object)"moving does not change the source position");
        }
        return true;
    }

    protected void swap(Position a, Position b) {
        if (a.equals(b)) {
            return;
        }
        Figure fa = this.getFigure(a);
        if (fa == a) {
            throw new IllegalArgumentException("do not specify positions with those figures on the field that will get swapped. Otherwise, their position information will get lost. But a==getFigure(a)");
        }
        if (fa == b) {
            throw new IllegalArgumentException("do not specify positions with those figures on the field that will get swapped. Otherwise, their position information will get lost. But b==getFigure(a)");
        }
        Figure fb = this.getFigure(b);
        if (fb == a) {
            throw new IllegalArgumentException("do not specify positions with those figures on the field that will get swapped. Otherwise, their position information will get lost. But a==getFigure(b)");
        }
        if (fb == b) {
            throw new IllegalArgumentException("do not specify positions with those figures on the field that will get swapped. Otherwise, their position information will get lost. But b==getFigure(b)");
        }
        this.internalSetFigure(b, null);
        this.setFigure(a, fb);
        this.setFigure(b, fa);
    }

    Rectangle boundsOf(Rectangle box, Position p) {
        Dimension dim = this.getDimension();
        int wFigure = box.width / dim.width;
        int hFigure = box.height / dim.height;
        return new Rectangle(wFigure * p.x, hFigure * p.y, wFigure, hFigure);
    }

    public void paint(Graphics g, Rectangle box) {
        Dimension dim = this.getDimension();
        int wFigure = box.width / dim.width;
        int hFigure = box.height / dim.height;
        if (wFigure == 0 || hFigure == 0) {
            throw new IllegalStateException("zero figure dimension: " + wFigure + "|" + hFigure);
        }
        for (int y = 0; y < dim.height; ++y) {
            for (int x = 0; x < dim.width; ++x) {
                Position p = new Position(x, y);
                Rectangle fr = this.boundsOf(box, p);
                Graphics fg = g.create(fr.x, fr.y, fr.width, fr.height);
                fr.setLocation(0, 0);
                fg.setColor((x & 1 ^ y & 1) == 0 ? Color.white : Color.darkGray);
                fg.fillRect(fr.x, fr.y, fr.width, fr.height);
                if (!this.isEmpty(p)) {
                    this.getFigure(p).paint(fg, fr);
                }
                fg.dispose();
            }
        }
    }

    public final int isBeating(Move move, Position destination) {
        if (!move.isBeating(move.length() - 1) || this.isEmpty(destination)) {
            return 0;
        }
        return this.getFigure(destination).getLeague();
    }

    public String toString() {
        Dimension dim = this.getDimension();
        StringBuffer sb = new StringBuffer(20 * dim.width * dim.height);
        for (int y = 0; y < dim.height; ++y) {
            for (int x = 0; x < dim.width; ++x) {
                sb.append(this.getFigure(new Position(x, y)));
                if (x >= dim.width - 1) continue;
                sb.append(',');
            }
            if (y >= dim.height - 1) continue;
            sb.append(";\n");
        }
        return this.getClass().getName() + "[" + dim + ":" + sb + "]";
    }

    static {
        $assertionsDisabled = !Field.class.desiredAssertionStatus();
        logger = Logger.getLogger(Field.class.getPackage().getName());
    }
}

