/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

class AwtResourceDecoder {
    private final ResourceBundle resources;
    private final Dictionary actions;

    public AwtResourceDecoder(ResourceBundle resources, Dictionary actions) {
        this.resources = resources;
        this.actions = actions;
    }

    public MenuBar createMenuBar() {
        MenuBar mb = new MenuBar();
        StringTokenizer menus = new StringTokenizer(this.resources.getString("menubar"));
        while (menus.hasMoreElements()) {
            String menu = (String)menus.nextElement();
            Menu m = this.createMenu(menu);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    public PopupMenu createPopupMenu() {
        PopupMenu menu = new PopupMenu(this.resources.getString("popup.label"));
        this.fill(menu, "popup");
        return menu;
    }

    protected Menu createMenu(String key) {
        Menu menu = new Menu(this.resources.getString(key + ".label"));
        this.fill(menu, key);
        return menu;
    }

    void fill(Menu menu, String key) {
        StringTokenizer items = new StringTokenizer(this.resources.getString(key));
        while (items.hasMoreElements()) {
            String item = (String)items.nextElement();
            if (item.equals("-")) {
                menu.addSeparator();
                continue;
            }
            menu.add(this.createMenuItem(item));
        }
    }

    protected MenuItem createMenuItem(String cmd) {
        MenuItem mi = new MenuItem(this.resources.getString(cmd + ".label"));
        String action = null;
        try {
            action = this.resources.getString(cmd + ".action");
        }
        catch (MissingResourceException trial) {
            // empty catch block
        }
        if (action == null) {
            action = cmd;
        }
        mi.setActionCommand(action);
        ActionListener a = (ActionListener)this.actions.get(action);
        if (a != null) {
            mi.addActionListener(a);
            mi.setEnabled(true);
        } else {
            mi.setEnabled(false);
        }
        return mi;
    }
}

