/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.game.AdversarySearch;
import orbital.game.Field;
import orbital.game.Figure;
import orbital.logic.functor.BinaryPredicate;
import orbital.logic.functor.Function;
import orbital.logic.functor.Predicates;
import orbital.math.ValueFactory;
import orbital.math.Values;
import orbital.robotic.Move;
import orbital.robotic.Position;

public class AlphaBetaPruning
extends AdversarySearch {
    static final Logger logger;
    private int maxDepth;
    private Function utility;
    private BinaryPredicate preference;
    private transient int currentDepth;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AlphaBetaPruning(int maxDepth, Function utility, BinaryPredicate preference) {
        this.setMaxDepth(maxDepth);
        this.setUtility(utility);
        this.setPreference(preference);
        this.currentDepth = 0;
    }

    public AlphaBetaPruning(int maxDepth, Function utility) {
        this(maxDepth, utility, Predicates.greater);
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    private void setMaxDepth(int argMaxDepth) {
        if (argMaxDepth < 0) {
            throw new IllegalArgumentException("illegal maxDepth " + argMaxDepth + " < 0");
        }
        this.maxDepth = argMaxDepth;
    }

    public Function getUtility() {
        return this.utility;
    }

    private void setUtility(Function argUtility) {
        if (argUtility == null) {
            throw new NullPointerException("not a utility function " + argUtility);
        }
        this.utility = argUtility;
    }

    protected BinaryPredicate getPreference() {
        return this.preference;
    }

    private void setPreference(BinaryPredicate newPreferenceRelation) {
        this.preference = newPreferenceRelation;
    }

    protected int getCurrentDepth() {
        return this.currentDepth;
    }

    private void setCurrentDepth(int newDepth) {
        this.currentDepth = newDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdversarySearch.Option solve(Field state) {
        AdversarySearch.Option option;
        block4: {
            if (!$assertionsDisabled && this.getCurrentDepth() != 0) {
                throw new AssertionError((Object)"search starts at currentDepth 0");
            }
            try {
                option = this.max_(state, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                Object var4_3 = null;
                if ($assertionsDisabled || this.getCurrentDepth() == 0) break block4;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!$assertionsDisabled && this.getCurrentDepth() != 0) {
                    throw new AssertionError((Object)"search ends at currentDepth 0");
                }
                throw throwable;
            }
            throw new AssertionError((Object)"search ends at currentDepth 0");
        }
        return option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdversarySearch.Option max_(Field state, double alpha, double beta) {
        if (!$assertionsDisabled && !this.isOurLeaguesTurn(state)) {
            throw new AssertionError((Object)"otherwise ours would not have an opportunity to move, anyway");
        }
        ++this.currentDepth;
        try {
            NoOption noOption;
            BinaryPredicate preference = this.getPreference();
            ValueFactory valueFactory = Values.getDefault();
            AdversarySearch.Option bestOption = new NoOption();
            bestOption.setUtility(alpha);
            if (this.cutOff(state)) {
                throw new AssertionError((Object)("should never cut off the very first node prior to attempting any moves. currentDepth=" + this.currentDepth + ", maxDepth=" + this.maxDepth));
            }
            Iterator s = this.successors(state);
            while (s.hasNext()) {
                AdversarySearch.Option p = (AdversarySearch.Option)s.next();
                double v = this.minimax(p.getState(), alpha, beta);
                p.setUtility(v);
                if (preference.apply(p, bestOption)) {
                    logger.log(Level.FINEST, "evaluate utility: {1} for {0} preferred to {2} of {3}", new Object[]{AlphaBetaPruning.format(v), p, AlphaBetaPruning.format(alpha), bestOption});
                    alpha = v;
                    bestOption = p;
                } else {
                    if (!$assertionsDisabled && bestOption == null) {
                        throw new AssertionError((Object)("always prefer choices to null, so we should have preferred " + p + " with " + v + " to best " + bestOption + " with " + alpha));
                    }
                    logger.log(Level.FINEST, "evaluate utility: {1} for {0} =< {2} for {3}", new Object[]{AlphaBetaPruning.format(v), p, AlphaBetaPruning.format(alpha), bestOption});
                }
                if (!(alpha >= beta)) continue;
                break;
            }
            if (bestOption instanceof NoOption) {
                if (!$assertionsDisabled && this.successors(state).hasNext() && alpha == Double.NEGATIVE_INFINITY && beta == Double.POSITIVE_INFINITY) {
                    throw new AssertionError((Object)"at least with usual arguments there must have been no successors in order to produce no best option");
                }
                noOption = null;
                return noOption;
            }
            if (!$assertionsDisabled && bestOption.getUtility() != alpha) {
                throw new AssertionError((Object)"the best move found so far, has utility alpha");
            }
            noOption = bestOption;
            return noOption;
        }
        finally {
            --this.currentDepth;
        }
    }

    static final Number format(double d) {
        return new Double(d);
    }

    private double minimax(Field state, double alpha, double beta) {
        return this.isOurLeaguesTurn(state) ? this.max(state, alpha, beta) : this.min(state, alpha, beta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double max(Field state, double alpha, double beta) {
        ++this.currentDepth;
        try {
            if (this.cutOff(state)) {
                double d = ((Number)this.getUtility().apply(state)).doubleValue();
                return d;
            }
            Iterator s = this.successors(state);
            while (s.hasNext()) {
                Field nextState = ((AdversarySearch.Option)s.next()).getState();
                if (!((alpha = Math.max(alpha, this.minimax(nextState, alpha, beta))) >= beta)) continue;
                double d = beta;
                return d;
            }
            double d = alpha;
            return d;
        }
        finally {
            --this.currentDepth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double min(Field state, double alpha, double beta) {
        ++this.currentDepth;
        try {
            if (this.cutOff(state)) {
                double d = ((Number)this.getUtility().apply(state)).doubleValue();
                return d;
            }
            Iterator s = this.successors(state);
            while (s.hasNext()) {
                Field nextState = ((AdversarySearch.Option)s.next()).getState();
                if (!((beta = Math.min(beta, this.minimax(nextState, alpha, beta))) <= alpha)) continue;
                double d = alpha;
                return d;
            }
            double d = beta;
            return d;
        }
        finally {
            --this.currentDepth;
        }
    }

    protected boolean isOurLeaguesTurn(Field state) {
        return this.getCurrentDepth() % 2 == 0;
    }

    protected boolean cutOff(Field state) {
        return this.currentDepth > this.maxDepth;
    }

    static {
        $assertionsDisabled = !AlphaBetaPruning.class.desiredAssertionStatus();
        logger = Logger.getLogger(AlphaBetaPruning.class.getName());
    }

    private static class NoOption
    extends AdversarySearch.Option {
        public NoOption() {
            super((Field)null, (Position)null, (Figure)null, (Move)null);
        }

        public String toString() {
            return this.getClass().getName();
        }
    }
}

