/*
 * Decompiled with CFR 0.152.
 */
package orbital.awt;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import orbital.math.MathUtilities;
import orbital.util.Utility;

public class TaggedPropertyEditorSupport
extends PropertyEditorSupport
implements PropertyEditor {
    private String[] tags;
    private Object[] values;
    private String[] initializers;

    protected TaggedPropertyEditorSupport(String[] tags, Object[] values, String[] javaInitializers) {
        if (tags.length != values.length) {
            throw new IllegalArgumentException("incompatible dimensions");
        }
        if (javaInitializers != null && javaInitializers.length != values.length) {
            throw new IllegalArgumentException("incompatible dimensions");
        }
        this.tags = tags;
        this.values = values;
        this.initializers = javaInitializers;
    }

    protected TaggedPropertyEditorSupport(String[] tags, Object[] values) {
        this(tags, values, null);
    }

    public String[] getTags() {
        return this.tags;
    }

    public String getAsText() {
        Object v = this.getValue();
        for (int i = 0; i < this.values.length; ++i) {
            if (!Utility.equals(this.values[i], v)) continue;
            return this.tags[i];
        }
        throw new IllegalStateException("an illegal value is set that is not an allowed tag: value=" + v + ", tags=" + MathUtilities.format(this.tags));
    }

    public String getJavaInitializationString() {
        if (this.initializers == null) {
            return super.getJavaInitializationString();
        }
        Object v = this.getValue();
        for (int i = 0; i < this.values.length; ++i) {
            if (!Utility.equals(this.values[i], v)) continue;
            return this.initializers[i];
        }
        throw new IllegalStateException("an illegal value is set that is not an allowed tag: value=" + v + ", tags=" + MathUtilities.format(this.tags));
    }

    public void setValue(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!Utility.equals(this.values[i], value)) continue;
            super.setValue(value);
            return;
        }
        throw new IllegalArgumentException("invalid value specified: '" + value + "'");
    }

    public void setAsText(String text) throws IllegalArgumentException {
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].equals(text)) continue;
            this.setValue(this.values[i]);
            return;
        }
        throw new IllegalArgumentException("invalid tag specified: '" + text + "'");
    }
}

