/*
 * Decompiled with CFR 0.152.
 */
package orbital.algorithm;

import java.util.NoSuchElementException;
import orbital.algorithm.Combinatorical;
import orbital.math.MathUtilities;

class NonrepetitivePermutation
extends Combinatorical {
    private static final long serialVersionUID = 5519106291934622529L;
    private int r;
    private int n;
    private int[] permutation;
    private boolean first = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NonrepetitivePermutation(int r, int n) {
        if (r > n) {
            throw new IllegalArgumentException("only r <= n permutations without repetition exist");
        }
        this.r = r;
        this.n = n;
        this.permutation = new int[r];
        for (int i = 0; i < this.permutation.length; ++i) {
            this.permutation[i] = i;
        }
        if (r < n) {
            throw new UnsupportedOperationException("r < n not yet implemented");
        }
    }

    public int count() {
        return MathUtilities.nPr(this.n, this.r);
    }

    public boolean hasNext() {
        int[] copy = (int[])this.permutation.clone();
        return this.first || NonrepetitivePermutation.permute(copy);
    }

    public int[] next() {
        if (this.first) {
            this.first = false;
            return this.permutation;
        }
        if (NonrepetitivePermutation.permute(this.permutation)) {
            return this.permutation;
        }
        if (this.r == this.n) {
            throw new NoSuchElementException();
        }
        if (!$assertionsDisabled && this.r >= this.n) {
            throw new AssertionError((Object)"r < n case because r <= n abd r == n is solved");
        }
        throw new UnsupportedOperationException("r < n not yet implemented");
    }

    public boolean hasPrevious() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int[] previous() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public static boolean permute(int[] permutation) {
        int first = 0;
        int last = permutation.length;
        if (first == last) {
            return false;
        }
        int i = first;
        if (++i == last) {
            return false;
        }
        i = last;
        --i;
        do {
            int ii;
            if (permutation[--i] >= permutation[ii]) continue;
            int j = last;
            while (permutation[i] >= permutation[--j]) {
            }
            int T = permutation[i];
            permutation[i] = permutation[j];
            permutation[j] = T;
            NonrepetitivePermutation.reverse(permutation, ii, last);
            return true;
        } while (i != first);
        NonrepetitivePermutation.reverse(permutation, first, last);
        return false;
    }

    private static void reverse(int[] permutation, int first, int last) {
        while (first < last) {
            int T = permutation[first];
            permutation[first++] = permutation[--last];
            permutation[last] = T;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[of " + this.r + " elements out of " + this.n + "]";
    }

    static {
        $assertionsDisabled = !NonrepetitivePermutation.class.desiredAssertionStatus();
    }
}

