/*
 * Decompiled with CFR 0.152.
 */
package functologic.game.computer;

import functologic.game.computer.ShiftedLogistic;
import java.io.Serializable;
import java.util.List;
import orbital.game.Field;
import orbital.math.MathUtilities;
import orbital.math.functional.Function;

public class OptimizedTinyHeuristic
implements orbital.logic.functor.Function,
Serializable {
    private static final long serialVersionUID = 8994687279257438625L;
    protected float[] weights;
    protected transient float potential;
    protected orbital.logic.functor.Function[] features;

    public OptimizedTinyHeuristic(orbital.logic.functor.Function[] functionArray, float[] fArray) {
        if (functionArray.length != fArray.length) {
            throw new IllegalArgumentException("same length expected, but " + functionArray.length + "!=" + fArray.length);
        }
        this.features = functionArray;
        this.weights = fArray;
    }

    public OptimizedTinyHeuristic(List list, float[] fArray) {
        this(list.toArray(new orbital.logic.functor.Function[0]), fArray);
    }

    protected OptimizedTinyHeuristic() {
    }

    public orbital.logic.functor.Function[] getFeatures() {
        return this.features;
    }

    public void setFeatures(orbital.logic.functor.Function[] functionArray) {
        this.features = functionArray;
    }

    public float[] getWeights() {
        return this.weights;
    }

    public void setWeights(float[] fArray) {
        this.weights = fArray;
    }

    protected Function getActivationFunction() {
        return new ShiftedLogistic();
    }

    public Object apply(Object object) {
        return new Float(this.apply(this.encode((Field)object)));
    }

    protected float apply(float[] fArray) {
        if (fArray.length != this.weights.length) {
            throw new IllegalArgumentException("illegal input length");
        }
        float f = 0.0f;
        for (int i = 0; i < this.weights.length; ++i) {
            f += this.weights[i] * fArray[i];
        }
        this.potential = f;
        return ShiftedLogistic.apply(f);
    }

    protected float[] encode(Field field) {
        float[] fArray = new float[this.features.length];
        for (int i = 0; i < this.features.length; ++i) {
            fArray[i] = ((Number)this.features[i].apply(field)).floatValue();
        }
        return fArray;
    }

    public static OptimizedTinyHeuristic asReadOnly(OptimizedTinyHeuristic optimizedTinyHeuristic) {
        return new OptimizedTinyHeuristic(optimizedTinyHeuristic.getFeatures(), optimizedTinyHeuristic.getWeights());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getWeights() == null || this.getFeatures() == null) {
            stringBuffer.append("weights=" + MathUtilities.format(this.getWeights()) + "\nfeatures=" + MathUtilities.format(this.getFeatures()));
        } else {
            for (int i = 0; i < this.getWeights().length; ++i) {
                stringBuffer.append((i > 0 ? ",\n" : "\n") + this.getWeights()[i] + "*" + this.getFeatures()[i]);
            }
        }
        return this.getClass().getName() + '[' + stringBuffer + ']';
    }

    public static orbital.logic.functor.Function create(orbital.logic.functor.Function[][] functionArray, float[][] fArray, orbital.logic.functor.Function function, int[] nArray) {
        if (functionArray.length != nArray.length || fArray.length != nArray.length) {
            throw new IllegalArgumentException("each heuristic is for one phase, so those arrays should have the same length");
        }
        orbital.logic.functor.Function[] functionArray2 = new orbital.logic.functor.Function[functionArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            functionArray2[i] = new OptimizedTinyHeuristic(functionArray[i], fArray[i]);
        }
        throw new UnsupportedOperationException("@todo");
    }

    public static class Bias
    implements orbital.logic.functor.Function,
    Serializable {
        private static final long serialVersionUID = 173349515309861126L;
        private static final Number MINUS_ONE = new Integer(-1);

        public final Object apply(Object object) {
            return MINUS_ONE;
        }
    }
}

