/*
 * Decompiled with CFR 0.152.
 */
package functologic.game.computer;

import functologic.game.computer.AlphaBetaPruning;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.game.AdversarySearch;
import orbital.game.Field;
import orbital.logic.functor.BinaryPredicate;
import orbital.logic.functor.Function;
import orbital.math.MathUtilities;

public class OptimisticAlphaBetaPruning
extends AlphaBetaPruning {
    static final Logger logger;
    private static final double tolerance = 1.0E-4;
    private transient int currentDepth = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OptimisticAlphaBetaPruning(int n, Function function, BinaryPredicate binaryPredicate) {
        super(n, function, binaryPredicate);
    }

    public OptimisticAlphaBetaPruning(int n, Function function) {
        super(n, function);
    }

    protected boolean isPreferred(double d, double d2, double d3, double d4) {
        return d > d3 || MathUtilities.equals(d, d3, 1.0E-4) && d2 > d4;
    }

    protected final boolean isPreferred(double d, double d2) {
        throw new InternalError("used isPreferred(double,double,double,double) instead");
    }

    protected int getCurrentDepth() {
        return this.currentDepth;
    }

    private void setCurrentDepth(int n) {
        this.currentDepth = n;
    }

    protected int descendTo(Field field, boolean bl) {
        return this.getCurrentDepth() + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdversarySearch.Option solve(Field field) {
        AdversarySearch.Option option;
        block4: {
            if (!$assertionsDisabled && this.getCurrentDepth() != 0) {
                throw new AssertionError((Object)"search starts at currentDepth 0");
            }
            try {
                option = this.max_(field, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                Object var4_3 = null;
                if ($assertionsDisabled || this.getCurrentDepth() == 0) break block4;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!$assertionsDisabled && this.getCurrentDepth() != 0) {
                    throw new AssertionError((Object)"search ends at currentDepth 0");
                }
                throw throwable;
            }
            throw new AssertionError((Object)"search ends at currentDepth 0");
        }
        return option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdversarySearch.Option max_(Field field, double d, double d2) {
        if (!$assertionsDisabled && !this.isOurLeaguesTurn(field)) {
            throw new AssertionError((Object)"otherwise ours would not have an opportunity to move, anyway");
        }
        int n = this.getCurrentDepth();
        this.setCurrentDepth(this.descendTo(field, true));
        try {
            AdversarySearch.Option option = null;
            double d3 = Double.NaN;
            if (this.cutOff(field)) {
                throw new AssertionError((Object)("should never cut off the very first node prior to attempting any moves. currentDepth=" + this.currentDepth + ", maxDepth=" + this.getMaxDepth()));
            }
            Object object = this.successors(field);
            while (object.hasNext()) {
                AdversarySearch.Option option2 = (AdversarySearch.Option)object.next();
                double[] dArray = this.minimax(option2.getState(), d, d2);
                double d4 = dArray[0];
                if (this.isPreferred(d4, dArray[1], d, d3)) {
                    logger.log(Level.FINEST, "evaluate utility: {1} for {0} preferred to {2} of {3}", new Object[]{this.format(d4), option2, this.format(d), option});
                    d = d4;
                    option = option2;
                    d3 = dArray[1];
                } else {
                    if (!$assertionsDisabled && option == null) {
                        throw new AssertionError((Object)("always prefer choices to null, but did not prefer " + option2 + " with " + dArray[0] + " (est " + dArray[1] + ") to best " + option + " with " + d + "(est " + d3 + ")"));
                    }
                    logger.log(Level.FINEST, "evaluate utility: {1} for {0} =< {2} for {3}", new Object[]{this.format(d4), option2, this.format(d), option});
                }
                if (!(d >= d2)) continue;
            }
            if (option != null) {
                option.setUtility(d);
            } else if (!$assertionsDisabled && this.successors(field).hasNext() && d == Double.NEGATIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
                throw new AssertionError((Object)"at least with usual arguments there must have been no successors in order to produce no best option");
            }
            object = option;
            return object;
        }
        finally {
            this.setCurrentDepth(n);
        }
    }

    private double[] minimax(Field field, double d, double d2) {
        return this.isOurLeaguesTurn(field) ? this.max(field, d, d2) : this.min(field, d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] max(Field field, double d, double d2) {
        int n = this.getCurrentDepth();
        this.setCurrentDepth(this.descendTo(field, true));
        double d3 = 0.0;
        int n2 = 0;
        try {
            if (this.cutOff(field)) {
                double[] dArray = OptimisticAlphaBetaPruning.estimateProbable(((Number)this.getUtility().apply(field)).doubleValue(), d3, n2);
                return dArray;
            }
            Object object = this.successors(field);
            while (object.hasNext()) {
                double d4 = this.minimax(((AdversarySearch.Option)object.next()).getState(), d, d2)[0];
                d3 += d4;
                ++n2;
                if (!((d = Math.max(d, d4)) >= d2)) continue;
                double[] dArray = OptimisticAlphaBetaPruning.estimateProbable(d2, d3, n2);
                return dArray;
            }
            object = OptimisticAlphaBetaPruning.estimateProbable(d, d3, n2);
            return object;
        }
        finally {
            this.setCurrentDepth(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] min(Field field, double d, double d2) {
        int n = this.getCurrentDepth();
        this.setCurrentDepth(this.descendTo(field, false));
        double d3 = 0.0;
        int n2 = 0;
        try {
            if (this.cutOff(field)) {
                double[] dArray = OptimisticAlphaBetaPruning.estimateProbable(((Number)this.getUtility().apply(field)).doubleValue(), d3, n2);
                return dArray;
            }
            Object object = this.successors(field);
            while (object.hasNext()) {
                double d4 = this.minimax(((AdversarySearch.Option)object.next()).getState(), d, d2)[0];
                d3 += d4;
                ++n2;
                if (!((d2 = Math.min(d2, d4)) <= d)) continue;
                double[] dArray = OptimisticAlphaBetaPruning.estimateProbable(d, d3, n2);
                return dArray;
            }
            object = OptimisticAlphaBetaPruning.estimateProbable(d2, d3, n2);
            return object;
        }
        finally {
            this.setCurrentDepth(n);
        }
    }

    private static double[] estimateProbable(double d, double d2, int n) {
        return new double[]{d, n == 0 ? d : d2 / (double)n};
    }

    private Object format(double d) {
        return d + "";
    }

    protected boolean isOurLeaguesTurn(Field field) {
        return this.currentDepth % 2 == 0;
    }

    protected boolean cutOff(Field field) {
        return this.currentDepth > this.getMaxDepth();
    }

    static {
        $assertionsDisabled = !OptimisticAlphaBetaPruning.class.desiredAssertionStatus();
        logger = Logger.getLogger(AlphaBetaPruning.class.getName());
    }
}

